/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLContext;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;

public class TryllianSSLContext
extends SSLContext {
    public void setRootCertificates(Enumeration certificates) throws CertificateEncodingException {
        while (certificates.hasMoreElements()) {
            X509Certificate certificate = (X509Certificate)certificates.nextElement();
            byte[] certBytes = certificate.getEncoded();
            this.root_list.add(certBytes);
        }
    }

    public void setLocalCertificates(Enumeration certificates) throws CertificateEncodingException {
        this.certificates = new Vector(1);
        while (certificates.hasMoreElements()) {
            X509Certificate certificate = (X509Certificate)certificates.nextElement();
            byte[] certBytes = certificate.getEncoded();
            this.certificates.add(certBytes);
        }
    }

    public void setPrivateKey(PrivateKey key) {
        if (key == null) {
            throw new NullPointerException("Private key cannot be null");
        }
        this.privateKey = key;
    }

    public void setDHParams(String dhParams) {
        try {
            this.loadDHParams(new StringBufferInputStream(dhParams));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Illegal DH params: " + ioe.getMessage());
        }
    }
}

