/*
 * Decompiled with CFR 0.152.
 */
package tryllian.util.properties;

import java.util.ArrayList;
import java.util.List;
import tryllian.util.properties.PropertyFacade;

class VariableExpander {
    private final PropertyFacade facade;

    public VariableExpander(PropertyFacade facade) {
        this.facade = facade;
    }

    public String expandVariables(String original) {
        return this.expandVariables(new ArrayList(), original);
    }

    public String expandVariables(List ignoredVars, String aString) {
        String expandedVariable;
        if (aString == null) {
            return "";
        }
        if (aString.length() <= 3) {
            return aString;
        }
        if (aString.indexOf("${") == -1) {
            return aString;
        }
        String[] division = VariableExpander.divideString(aString);
        String prefix = division[0];
        String variable = division[1];
        String remainder = division[2];
        String replacedVariable = this.replaceVariable(ignoredVars, variable);
        String expandedRemainder = this.expandVariables(ignoredVars, remainder);
        if (!"".equals(variable) && !ignoredVars.contains(variable)) {
            ignoredVars.add(variable);
            expandedVariable = this.expandVariables(ignoredVars, replacedVariable);
            ignoredVars.remove(variable);
        } else {
            expandedVariable = replacedVariable;
        }
        return prefix + expandedVariable + expandedRemainder;
    }

    private String replaceVariable(List ignoredVars, String variable) {
        if (variable == null) {
            return "";
        }
        String variableName = VariableExpander.guardedSubstring(variable, 2, variable.length() - 1);
        if (ignoredVars.contains(variableName)) {
            return "";
        }
        if (variableName.equals("")) {
            return "";
        }
        String result = null;
        try {
            result = this.facade.getObjectProp(variableName).toString();
        }
        catch (NullPointerException e) {
            System.err.println("facade.getObjectProp returned null when replacing " + variableName + " within " + variable);
            e.printStackTrace();
        }
        return result == null ? "" : result;
    }

    private static String[] divideString(String s) {
        String[] result = new String[]{"", "", ""};
        int variableStart = VariableExpander.findVariableStart(s);
        int variableEnd = VariableExpander.findVariableEnd(s, variableStart);
        if (variableStart < 0) {
            result[0] = s;
        } else if (variableEnd < variableStart) {
            result[0] = s;
        } else {
            result[0] = s.substring(0, variableStart);
            result[1] = s.substring(variableStart, variableEnd + 1);
            result[2] = s.substring(variableEnd + 1);
        }
        return result;
    }

    private static int findVariableStart(String s) {
        if (s.length() <= 3) {
            return -1;
        }
        int firstDollarIndex = s.indexOf(36);
        if (firstDollarIndex < 0) {
            return -1;
        }
        if (firstDollarIndex > 0 && s.charAt(firstDollarIndex - 1) == '\\') {
            return VariableExpander.findVariableStart(VariableExpander.guardedSubstring(s, firstDollarIndex + 1));
        }
        int expectedBracketIndex = firstDollarIndex + 1;
        if (expectedBracketIndex < s.length() && s.charAt(expectedBracketIndex) == '{') {
            return firstDollarIndex;
        }
        return VariableExpander.findVariableStart(VariableExpander.guardedSubstring(s, firstDollarIndex + 1));
    }

    private static int findVariableEnd(String s, int after) {
        return s.indexOf(125, after);
    }

    private static String guardedSubstring(String s, int fromIndex, int toIndex) {
        String result = "";
        try {
            result = s.substring(fromIndex, toIndex);
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        return result;
    }

    private static String guardedSubstring(String s, int fromIndex) {
        return VariableExpander.guardedSubstring(s, fromIndex, s.length());
    }
}

