/*
 * Decompiled with CFR 0.152.
 */
package tryllian.util.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import tryllian.util.properties.PropertyBase;
import tryllian.util.properties.PropertyDefinition;
import tryllian.util.properties.VariableExpander;

public class PropertyFacade {
    private final Properties properties;
    private final PropertyBase base;
    private final VariableExpander expander;
    private final File propertyFile;

    public PropertyFacade(PropertyBase base) {
        this.base = base;
        this.properties = new Properties();
        this.expander = new VariableExpander(this);
        this.propertyFile = null;
    }

    public PropertyFacade(Properties props) {
        this.base = new PropertyBase();
        this.properties = props;
        this.expander = new VariableExpander(this);
        this.propertyFile = null;
    }

    public PropertyFacade(PropertyBase base, Properties props) {
        this.base = base;
        this.properties = new Properties(props);
        this.expander = new VariableExpander(this);
        this.propertyFile = null;
    }

    public PropertyFacade(PropertyBase base, File file) throws IOException {
        this.propertyFile = file;
        this.base = base;
        this.properties = new Properties();
        this.expander = new VariableExpander(this);
        FileInputStream in = new FileInputStream(file);
        this.properties.load(in);
        in.close();
    }

    public PropertyFacade(PropertyBase base, File file, Properties props) throws IOException {
        this.propertyFile = file;
        this.base = base;
        this.properties = new Properties();
        FileInputStream in = new FileInputStream(file);
        this.properties.load(in);
        in.close();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            this.properties.setProperty(key, value);
        }
        this.expander = new VariableExpander(this);
    }

    public Properties getProperties() {
        Properties result = (Properties)this.properties.clone();
        Iterator<Object> it = result.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String expand = this.getProp(key);
            if (expand == null) continue;
            result.setProperty(key, expand.toString());
        }
        this.base.getExpandedProperties(result, this);
        return result;
    }

    public void saveProperties() throws IOException {
        FileOutputStream out = new FileOutputStream(this.propertyFile);
        this.properties.store(out, "Saved by ARE PropertyFacade");
        out.close();
    }

    public boolean getBoolProp(String key) {
        String value = this.properties.getProperty(key);
        PropertyDefinition propdef = this.base.getPropertyDefinition(key);
        if (propdef == null) {
            if (value != null) {
                return Boolean.valueOf(value);
            }
            return false;
        }
        if (!"bool".equals(propdef.getType())) {
            throw new IllegalArgumentException("Property " + key + " is not " + " a boolean property ");
        }
        return (Boolean)propdef.getValue(value);
    }

    public int getIntProp(String key) {
        String value = this.properties.getProperty(key);
        PropertyDefinition propdef = this.base.getPropertyDefinition(key);
        if (propdef == null) {
            if (value != null) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Value of " + key + " is not a number but " + value);
                }
            }
            throw new IllegalArgumentException("Value of " + key + " is not set");
        }
        if (!"int".equals(propdef.getType())) {
            throw new IllegalArgumentException("Property " + key + " is not " + " an integer property ");
        }
        return (Integer)propdef.getValue(value);
    }

    public long getLongProp(String key) {
        String value = this.properties.getProperty(key);
        PropertyDefinition propdef = this.base.getPropertyDefinition(key);
        if (propdef == null) {
            if (value != null) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Value of " + key + " is not a long but " + value);
                }
            }
            throw new IllegalArgumentException("Value of " + key + " is not set");
        }
        if (!"long".equals(propdef.getType())) {
            throw new IllegalArgumentException("Property " + key + " is not " + " a long property ");
        }
        return (Long)propdef.getValue(value);
    }

    public String getStringProp(String key) {
        String value = this.properties.getProperty(key);
        PropertyDefinition propdef = this.base.getPropertyDefinition(key);
        if (propdef != null) {
            if (!"string".equals(propdef.getType())) {
                throw new IllegalArgumentException("Property " + key + " is not a String.");
            }
            return this.expander.expandVariables((String)propdef.getValue(value));
        }
        return this.expander.expandVariables(value);
    }

    public String[] getStringArrayProp(String key) {
        String line = this.getStringProp(key);
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, ", \t");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result.toArray(new String[result.size()]);
    }

    public String getProp(String key) {
        Object value = this.getObjectProp(key);
        return value == null ? null : this.expander.expandVariables(value.toString());
    }

    Object getObjectProp(String key) {
        String value = this.properties.getProperty(key);
        PropertyDefinition propdef = this.base.getPropertyDefinition(key);
        if (propdef == null) {
            return value;
        }
        return propdef.getValue(value);
    }

    public void setProp(String key, boolean value) {
        this.properties.setProperty(key, String.valueOf(value));
    }

    public void setProp(String key, int value) {
        this.properties.setProperty(key, String.valueOf(value));
    }

    public void setProp(String key, long value) {
        this.properties.setProperty(key, String.valueOf(value));
    }

    public void setProp(String key, String value) {
        this.properties.setProperty(key, String.valueOf(value));
    }

    public void setProp(String key, String[] value) {
        StringBuffer sb = new StringBuffer(value.length);
        for (int i = 0; i < value.length; ++i) {
            sb.append(value[i]);
            sb.append(",");
        }
        this.properties.setProperty(key, sb.toString());
    }

    public String toString() {
        return "[PropertyFacade base: " + this.base + " expander: " + this.expander + " file: " + this.propertyFile + " properties: " + this.properties + "]";
    }
}

