/*
 * Decompiled with CFR 0.152.
 */
package tryllian.util.properties;

public class PropertyDefinition {
    private String key;
    private String type;
    private Object defaultValue;

    public PropertyDefinition(String key, int defaultValue) {
        this.key = key;
        this.type = "int";
        this.defaultValue = new Integer(defaultValue);
    }

    public PropertyDefinition(String key, boolean defaultValue) {
        this.key = key;
        this.type = "bool";
        this.defaultValue = new Boolean(defaultValue);
    }

    public PropertyDefinition(String key, long defaultValue) {
        this.key = key;
        this.type = "long";
        this.defaultValue = new Long(defaultValue);
    }

    public PropertyDefinition(String key, String defaultValue) {
        this.key = key;
        this.type = "string";
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int defaultValue) {
        if (!"int".equals(this.type)) {
            this.complain(new Integer(defaultValue));
        }
        this.defaultValue = new Integer(defaultValue);
    }

    public void setDefaultValue(boolean defaultValue) {
        if (!"bool".equals(this.type)) {
            this.complain(new Boolean(defaultValue));
        }
        this.defaultValue = new Boolean(defaultValue);
    }

    public void setDefaultValue(long defaultValue) {
        if (!"long".equals(this.type)) {
            this.complain(new Long(defaultValue));
        }
        this.defaultValue = new Long(defaultValue);
    }

    public void setDefaultValue(String defaultValue) {
        if (!"string".equals(this.type)) {
            this.complain(defaultValue);
        }
        this.defaultValue = defaultValue;
    }

    public Object getValue(String value) {
        if (value == null) {
            return this.defaultValue;
        }
        if ("bool".equals(this.type)) {
            return new Boolean(value);
        }
        if ("int".equals(this.type)) {
            return new Integer(value);
        }
        if ("long".equals(this.type)) {
            return new Long(value);
        }
        if ("string".equals(this.type)) {
            return value;
        }
        return null;
    }

    private void complain(Object value) {
        throw new IllegalArgumentException("Property " + this.key + ": value " + value + " is not a " + this.type);
    }

    public String toString() {
        return "Property Definition: " + this.key + ", " + this.type + ", " + this.defaultValue;
    }
}

