/*
 * Decompiled with CFR 0.152.
 */
package tryllian.util.properties;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import tryllian.util.properties.PropertyDefinition;
import tryllian.util.properties.PropertyFacade;

public class PropertyBase {
    static final String INT = "int";
    static final String BOOL = "bool";
    static final String LONG = "long";
    static final String STRING = "string";
    private final Map propertyMap = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    protected PropertyBase() {
        this.setValues();
    }

    public PropertyDefinition getPropertyDefinition(String key) {
        return (PropertyDefinition)this.propertyMap.get(key);
    }

    private void setValues() {
        Class<?> theClass = this.getClass();
        Field[] fields = theClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            Class<?> type = field.getType();
            int mod = field.getModifiers();
            if (!type.equals(class$java$lang$String == null ? PropertyBase.class$("java.lang.String") : class$java$lang$String) || name.endsWith("DEFAULT") || !Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !Modifier.isFinal(mod)) continue;
            String key = null;
            Object value = null;
            try {
                PropertyDefinition propDef;
                key = (String)field.get(null);
                try {
                    Field default_field = theClass.getField(name + "_DEFAULT");
                    value = default_field.get(null);
                }
                catch (NoSuchFieldException nsfe) {
                    value = null;
                }
                if (value == null || value instanceof String) {
                    propDef = new PropertyDefinition(key, (String)value);
                } else if (value instanceof Integer) {
                    int j = (Integer)value;
                    propDef = new PropertyDefinition(key, j);
                } else if (value instanceof Boolean) {
                    boolean b = (Boolean)value;
                    propDef = new PropertyDefinition(key, b);
                } else if (value instanceof Long) {
                    long l = (Long)value;
                    propDef = new PropertyDefinition(key, l);
                } else {
                    throw new Error("unsupported type: " + value.getClass());
                }
                this.propertyMap.put(key, propDef);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new InternalError(theClass + " name: " + name + " key: " + key + " value: " + value + " error: " + t);
            }
        }
    }

    void getExpandedProperties(Properties properties, PropertyFacade facade) {
        Iterator it = this.propertyMap.entrySet().iterator();
        while (it.hasNext()) {
            String value;
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (properties.get(key) != null || (value = facade.getProp(key)) == null) continue;
            properties.setProperty(key, value.toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(":{");
        Iterator it = this.propertyMap.entrySet().iterator();
        boolean has_next = it.hasNext();
        while (has_next) {
            Map.Entry entry = it.next();
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append(((PropertyDefinition)entry.getValue()).getDefaultValue());
            has_next = it.hasNext();
            if (!has_next) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

