/*
 * Decompiled with CFR 0.152.
 */
package tryllian.util.encode;

import java.io.IOException;

public class StringEscaper {
    public static char[] escape(String text) {
        char[] source = text.toCharArray();
        int resultSize = 0;
        for (int i = 0; i < source.length; ++i) {
            char c = source[i];
            if (c == '<' || c == '>' || c == '&' || c == '\"') {
                resultSize += 5;
                continue;
            }
            ++resultSize;
        }
        if (resultSize == source.length) {
            return source;
        }
        char[] result = new char[resultSize];
        int resultIndex = 0;
        block7: for (int sourceIndex = 0; sourceIndex < source.length; ++sourceIndex) {
            char c = source[sourceIndex];
            switch (c) {
                case '<': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 54;
                    result[resultIndex++] = 48;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                case '>': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 54;
                    result[resultIndex++] = 50;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                case '&': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 51;
                    result[resultIndex++] = 56;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                case '\"': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 51;
                    result[resultIndex++] = 52;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                default: {
                    result[resultIndex++] = c;
                }
            }
        }
        return result;
    }

    public static String escapeLT_GT_QUOT(String text) {
        if (text == null) {
            return "";
        }
        char[] source = text.toCharArray();
        int resultSize = 0;
        for (int i = 0; i < source.length; ++i) {
            char c = source[i];
            if (c == '<' || c == '>' || c == '&' || c == '\"') {
                resultSize += 5;
                continue;
            }
            ++resultSize;
        }
        if (resultSize == source.length) {
            return text;
        }
        char[] result = new char[resultSize];
        int resultIndex = 0;
        block7: for (int sourceIndex = 0; sourceIndex < source.length; ++sourceIndex) {
            char c = source[sourceIndex];
            switch (c) {
                case '<': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 54;
                    result[resultIndex++] = 48;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                case '>': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 54;
                    result[resultIndex++] = 50;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                case '&': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 51;
                    result[resultIndex++] = 56;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                case '\"': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 51;
                    result[resultIndex++] = 52;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                default: {
                    result[resultIndex++] = c;
                }
            }
        }
        return new String(result);
    }

    public static StringBuffer createCDATA(String text) throws IOException {
        StringBuffer result = new StringBuffer("<![CDATA[");
        StringEscaper.writeCDATAInner(result, text);
        result.append("]]>");
        return result;
    }

    private static void writeCDATAInner(StringBuffer result, String cdata) throws IOException {
        if (cdata == null) {
            return;
        }
        int breakIndex = cdata.indexOf("]]>");
        if (breakIndex != -1) {
            result.append(cdata.substring(0, breakIndex));
            result.append("]]]]><![CDATA[>");
            StringEscaper.writeCDATAInner(result, cdata.substring(breakIndex + 3));
        } else {
            result.append(cdata);
        }
    }
}

