/*
 * Decompiled with CFR 0.152.
 */
package tryllian.util.encode;

import com.tryllian.are.common.serialization.ClassLoaderInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Base64 {
    private static final char[] GETCHAR = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private Base64() {
    }

    public static String objectToString(Object object) throws IOException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        ObjectOutputStream objstream = new ObjectOutputStream(ba);
        objstream.writeObject(object);
        objstream.flush();
        return Base64.encode(ba.toByteArray());
    }

    public static Object stringToObject(String string) throws ClassNotFoundException, IOException {
        byte[] bytes = Base64.decode(string);
        ByteArrayInputStream ba = new ByteArrayInputStream(bytes);
        ObjectInputStream obj = new ObjectInputStream(ba);
        return obj.readObject();
    }

    public static Object stringToObject(String string, ClassLoader loader) throws ClassNotFoundException, IOException {
        byte[] bytes = Base64.decode(string);
        ByteArrayInputStream ba = new ByteArrayInputStream(bytes);
        ClassLoaderInputStream obj = new ClassLoaderInputStream(ba, loader);
        return obj.readObject();
    }

    public static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer((raw.length * 4 + 3) / 3);
        char[] base64block = new char[4];
        for (int i = 0; i < raw.length; i += 3) {
            Base64.encodeBlock(raw, i, base64block);
            encoded.append(base64block);
        }
        return encoded.toString();
    }

    public static byte[] decode(String base64) {
        int pad = 0;
        if (base64.length() > 0) {
            int i = base64.length() - 1;
            while (base64.charAt(i) == '=') {
                ++pad;
                --i;
            }
        }
        int length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawIndex = 0;
        try {
            for (int i = 0; i < base64.length(); i += 4) {
                int block = (Base64.getValue(base64.charAt(i)) << 18) + (Base64.getValue(base64.charAt(i + 1)) << 12) + (Base64.getValue(base64.charAt(i + 2)) << 6) + Base64.getValue(base64.charAt(i + 3));
                for (int j = 0; j < 3 && rawIndex + j < raw.length; ++j) {
                    raw[rawIndex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
                }
                rawIndex += 3;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Not a Base64 string");
        }
        return raw;
    }

    private static void encodeBlock(byte[] raw, int offset, char[] base64) {
        int i;
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        for (i = 0; i <= end; ++i) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
        }
        for (i = 0; i < 4; ++i) {
            int sixbit = block >> 6 * (3 - i) & 0x3F;
            base64[i] = GETCHAR[sixbit];
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
    }

    private static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        throw new IllegalArgumentException("Illegal character in Base64: " + c);
    }
}

