/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.xml;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMWriter
extends FilterWriter {
    private static final char[] DOCTYPE_CHARS = "<!DOCTYPE ".toCharArray();
    private static final char[] CLOSETAG_START_CHARS = "</".toCharArray();
    private static final char[] FASTCLOSETAG_END_CHARS = "/>".toCharArray();
    private static final char[] EQUALSQUOTE_CHARS = "=\"".toCharArray();
    private static final char[] COMMENT_START_CHARS = "<!--".toCharArray();
    private static final char[] COMMENT_END_CHARS = "-->".toCharArray();
    private boolean writeXmlDecl = true;
    private boolean writeDocType = true;

    public DOMWriter(Writer out) {
        super(out);
    }

    public void writeDOM(Node node) throws DOMException, IOException {
        if (node == null) {
            return;
        }
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                this.writeDOM((Attr)node);
                break;
            }
            case 1: {
                this.writeDOM((Element)node);
                break;
            }
            case 4: {
                this.writeDOM((CDATASection)node);
                break;
            }
            case 3: {
                this.writeDOM((Text)node);
                break;
            }
            case 8: {
                this.writeDOM((Comment)node);
                break;
            }
            case 5: {
                this.writeDOM((EntityReference)node);
                break;
            }
            case 6: {
                this.writeDOM((Entity)node);
                break;
            }
            case 12: {
                this.writeDOM((Notation)node);
                break;
            }
            case 9: {
                this.writeDOM((Document)node);
                break;
            }
            case 10: {
                this.writeDOM((DocumentType)node);
                break;
            }
            case 7: {
                this.writeDOM((ProcessingInstruction)node);
                break;
            }
            case 11: {
                this.writeDOM((DocumentFragment)node);
                break;
            }
            default: {
                this.write("<!-- Cannot write unsupported node-type ");
                this.write(node.getNodeType());
                this.write(" with node-name ");
                this.write(node.getNodeName());
                this.write(" and classname ");
                this.write(node.getClass().getName());
                this.write(" -->");
                throw new RuntimeException("Unsupported note-type");
            }
        }
    }

    public void writeDOM(Document document) throws DOMException, IOException {
        if (this.writeXmlDecl) {
            this.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        }
        this.writeChildren(document);
    }

    public void writeDOM(DocumentFragment fragment) throws DOMException, IOException {
        this.writeChildren(fragment);
    }

    public void writeDOM(Entity entity) throws DOMException, IOException {
        if (entity == null) {
            return;
        }
        this.write("<!-- Entity public id is " + entity.getPublicId() + ", system id is " + entity.getSystemId() + ", notationName is " + entity.getNotationName() + ", name is " + entity.getNodeName() + "-->");
    }

    public void writeDOM(Notation notation) throws DOMException, IOException {
        if (notation == null) {
            return;
        }
        this.write("<!-- Notation public id is " + notation.getPublicId() + ", system id is " + notation.getSystemId() + ", name is " + notation.getNodeName() + "-->");
    }

    public void writeDOM(EntityReference entityRef) throws DOMException, IOException {
        this.writeChildren(entityRef);
    }

    public void writeDOM(DocumentType docType) throws DOMException, IOException {
        if (docType == null) {
            return;
        }
        if (this.writeDocType) {
            this.write(DOCTYPE_CHARS);
            this.write(docType.getName());
            this.write(62);
        }
    }

    public void writeDOM(Element element) throws DOMException, IOException {
        if (element == null) {
            return;
        }
        this.write(60);
        this.write(element.getTagName());
        NamedNodeMap attrMap = element.getAttributes();
        int mapSize = attrMap.getLength();
        for (int attr = 0; attr < mapSize; ++attr) {
            this.write(32);
            this.writeDOM((Attr)attrMap.item(attr));
        }
        if (element.hasChildNodes()) {
            this.write(62);
            this.writeChildren(element);
            this.write(CLOSETAG_START_CHARS);
            this.write(element.getTagName());
            this.write(62);
        } else {
            this.write(FASTCLOSETAG_END_CHARS);
        }
    }

    public void writeDOM(Attr attribute) throws DOMException, IOException {
        if (attribute == null) {
            return;
        }
        this.write(attribute.getName());
        this.write(EQUALSQUOTE_CHARS);
        this.write(this.escapeLT_GT_QUOT(attribute.getValue()));
        this.write(34);
    }

    public void writeDOM(Text text) throws DOMException, IOException {
        if (text == null) {
            return;
        }
        this.write(this.escapeLT_GT_QUOT(text.getData()));
    }

    public void writeDOM(ProcessingInstruction pi) throws DOMException, IOException {
        if (pi == null) {
            return;
        }
        this.write("<?");
        this.write(pi.getTarget());
        this.write(32);
        this.write(pi.getData());
        this.write("?>");
    }

    public void writeDOM(CDATASection cdata) throws DOMException, IOException {
        if (cdata == null) {
            return;
        }
        this.write("<![CDATA[");
        this.writeCDATAInner(cdata.getData());
        this.write("]]>");
    }

    public void writeDOM(Comment comment) throws DOMException, IOException {
        if (comment == null) {
            return;
        }
        this.write(COMMENT_START_CHARS);
        this.writeCommentInner(comment.getData());
        this.write(COMMENT_END_CHARS);
    }

    private void writeChildren(Node node) throws DOMException, IOException {
        if (node == null) {
            return;
        }
        NodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        int listSize = children.getLength();
        for (int childIndex = 0; childIndex < listSize; ++childIndex) {
            this.writeDOM(children.item(childIndex));
        }
    }

    private char[] escapeLT_GT_QUOT(String text) {
        if (text == null) {
            return new char[0];
        }
        char[] source = text.toCharArray();
        int resultSize = 0;
        for (int i = 0; i < source.length; ++i) {
            char c = source[i];
            if (c == '<' || c == '>' || c == '&' || c == '\"') {
                resultSize += 5;
                continue;
            }
            ++resultSize;
        }
        if (resultSize == source.length) {
            return source;
        }
        char[] result = new char[resultSize];
        int resultIndex = 0;
        block7: for (int sourceIndex = 0; sourceIndex < source.length; ++sourceIndex) {
            char c = source[sourceIndex];
            switch (c) {
                case '<': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 54;
                    result[resultIndex++] = 48;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                case '>': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 54;
                    result[resultIndex++] = 50;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                case '&': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 51;
                    result[resultIndex++] = 56;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                case '\"': {
                    result[resultIndex++] = 38;
                    result[resultIndex++] = 35;
                    result[resultIndex++] = 51;
                    result[resultIndex++] = 52;
                    result[resultIndex++] = 59;
                    continue block7;
                }
                default: {
                    result[resultIndex++] = c;
                }
            }
        }
        return result;
    }

    private void writeCommentInner(String comment) throws IOException {
        if (comment == null) {
            return;
        }
        int breakIndex = comment.indexOf("-->");
        if (breakIndex != -1) {
            this.write(comment.substring(0, breakIndex));
            this.write("- ->");
            this.writeCommentInner(comment.substring(breakIndex + 3));
        } else {
            this.write(comment);
        }
    }

    private void writeCDATAInner(String cdata) throws IOException {
        if (cdata == null) {
            return;
        }
        int breakIndex = cdata.indexOf("]]>");
        if (breakIndex != -1) {
            this.write(cdata.substring(0, breakIndex));
            this.write("]]]]><![CDATA[>");
            this.writeCDATAInner(cdata.substring(breakIndex + 3));
        } else {
            this.write(cdata);
        }
    }
}

