/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.security;

import java.security.Security;
import java.util.StringTokenizer;

public class Provider {
    private static boolean installed = false;
    public static final String SECURITY_PROVIDERS_DEFAULT = "org.bouncycastle.jce.provider.BouncyCastleProvider";

    public static void install() {
        if (installed) {
            return;
        }
        String classNames = SECURITY_PROVIDERS_DEFAULT;
        StringTokenizer tok = new StringTokenizer(classNames);
        while (tok.hasMoreTokens()) {
            String className = tok.nextToken();
            try {
                Class<?> aClass = Class.forName(className);
                Security.addProvider((java.security.Provider)aClass.newInstance());
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load security provider " + className);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException("Could not instantiate security provider " + className);
            }
            catch (IllegalAccessException iee) {
                throw new RuntimeException("Could not access security provider " + className);
            }
        }
        installed = true;
    }
}

