/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.security;

import com.tryllian.are.security.CertificateChainModel;
import com.tryllian.are.security.CertificateModel;
import com.tryllian.are.security.DistinguishedNameModel;
import com.tryllian.are.security.KeyStoreEvent;
import com.tryllian.are.security.KeyStoreListener;
import com.tryllian.are.security.MissingCertificateException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class KeyStoreModel {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tryllian$are$security$KeyStoreModel == null ? (class$com$tryllian$are$security$KeyStoreModel = KeyStoreModel.class$("com.tryllian.are.security.KeyStoreModel")) : class$com$tryllian$are$security$KeyStoreModel));
    private static final String KEYSTORE_DEFAULT_TYPE = "jks";
    private volatile KeyStore keyStore;
    private File file;
    private boolean modified = false;
    private char[] password = null;
    private List listeners = new ArrayList();
    static /* synthetic */ Class class$com$tryllian$are$security$KeyStoreModel;

    protected KeyStoreModel() throws KeyStoreException {
        this.initialize();
    }

    public void initialize() throws KeyStoreException {
        try {
            this.keyStore = KeyStore.getInstance(KEYSTORE_DEFAULT_TYPE);
            this.keyStore.load(null, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not initialize keystore", (Throwable)e);
            return;
        }
        this.file = null;
        this.modified = false;
        this.password = null;
        this.fireKeyStoreChanged();
    }

    public static KeyStoreModel getInstance() throws KeyStoreException {
        return new KeyStoreModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyStoreModel load(File input, char[] passphrase) throws CertificateException, IOException, NoSuchAlgorithmException {
        FileInputStream fis;
        KeyStoreModel result;
        block3: {
            BufferedInputStream in = null;
            result = null;
            fis = new FileInputStream(input);
            try {
                in = new BufferedInputStream(fis);
                this.file = input;
                result = this.load(in, passphrase);
                Object var7_6 = null;
                if (in == null) break block3;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (in != null) {
                    in.close();
                }
                fis.close();
                throw throwable;
            }
            in.close();
        }
        fis.close();
        return result;
    }

    public KeyStoreModel load(InputStream input, char[] passphrase) throws CertificateException, IOException, NoSuchAlgorithmException {
        this.keyStore.load(input, passphrase);
        this.modified = false;
        this.password = passphrase;
        this.fireKeyStoreChanged();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(File output, char[] passphrase) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        FileOutputStream fos;
        block3: {
            fos = null;
            BufferedOutputStream out = null;
            fos = new FileOutputStream(output);
            try {
                out = new BufferedOutputStream(fos);
                this.keyStore.store(out, passphrase);
                Object var6_5 = null;
                if (out == null) break block3;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (out != null) {
                    out.flush();
                    out.close();
                }
                fos.close();
                throw throwable;
            }
            out.flush();
            out.close();
        }
        fos.close();
        this.file = output;
        this.modified = false;
        this.fireKeyStoreSaved();
    }

    public File getFile() {
        return this.file;
    }

    public char[] getPassword() {
        return this.password;
    }

    public boolean isModified() {
        return this.modified;
    }

    public Enumeration aliases() throws KeyStoreException {
        return this.keyStore.aliases();
    }

    public String[] getKeyAliases() throws KeyStoreException {
        ArrayList<String> result = new ArrayList<String>();
        int size = 0;
        Enumeration e = this.aliases();
        while (e.hasMoreElements()) {
            String current = (String)e.nextElement();
            if (!this.isKeyEntry(current)) continue;
            result.add(current);
            ++size;
        }
        return result.toArray(new String[size]);
    }

    public X509Certificate[] getCertificates() throws KeyStoreException {
        X509Certificate[] result = new X509Certificate[this.size()];
        int currentIndex = 0;
        Enumeration aliases = this.aliases();
        while (aliases.hasMoreElements()) {
            X509Certificate currentCertificate;
            String currentAlias = (String)aliases.nextElement();
            result[currentIndex] = currentCertificate = this.getCertificate(currentAlias).getCertificate();
            ++currentIndex;
        }
        return result;
    }

    public boolean containsAlias(String alias) throws KeyStoreException {
        return this.keyStore.containsAlias(alias);
    }

    public void deleteEntry(String name) throws KeyStoreException {
        this.keyStore.deleteEntry(name);
        this.modified = true;
        this.fireEntryRemoved(name);
    }

    public CertificateModel getCertificate(String alias) throws KeyStoreException {
        if (alias == null) {
            return null;
        }
        try {
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
            if (cert != null) {
                return new CertificateModel(cert);
            }
            return null;
        }
        catch (ClassCastException cce) {
            return null;
        }
        catch (CertificateException ce) {
            LOG.error((Object)("Could not get certificate for alias " + alias), (Throwable)ce);
            return null;
        }
    }

    public String getCertificateAlias(CertificateModel certificate) throws KeyStoreException {
        return this.keyStore.getCertificateAlias(certificate.getCertificate());
    }

    public CertificateModel getCertificate(DistinguishedNameModel subjectDN, boolean[] subjectID) throws KeyStoreException {
        Enumeration aliases = this.aliases();
        while (aliases.hasMoreElements()) {
            CertificateModel current = this.getCertificate((String)aliases.nextElement());
            if (!current.getSubjectDN().equals(subjectDN) || !Arrays.equals(subjectID, current.getSubjectUniqueID())) continue;
            return current;
        }
        return null;
    }

    public CertificateModel getSigningCertificate(CertificateModel certificate) throws MissingCertificateException, KeyStoreException {
        boolean[] issuerID;
        if (certificate.isRootCertificate()) {
            return certificate;
        }
        DistinguishedNameModel issuer = certificate.getIssuerDN();
        CertificateModel result = this.getCertificate(issuer, issuerID = certificate.getIssuerUniqueID());
        if (result == null) {
            throw new MissingCertificateException(issuer, issuerID);
        }
        return result;
    }

    public X509Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        Certificate[] result = this.keyStore.getCertificateChain(alias);
        if (result == null) {
            return null;
        }
        X509Certificate[] correctResult = new X509Certificate[result.length];
        try {
            for (int i = 0; i < result.length; ++i) {
                correctResult[i] = (X509Certificate)result[i];
            }
            return correctResult;
        }
        catch (ClassCastException cce) {
            LOG.error((Object)("Could not get the chain of certificates for alias " + alias), (Throwable)cce);
            return null;
        }
    }

    public CertificateChainModel constructCertificateChain(CertificateModel certificate) throws KeyStoreException, MissingCertificateException {
        X509Certificate[] result = null;
        String alias = this.getCertificateAlias(certificate);
        if (alias != null && (result = this.getCertificateChain(alias)) != null) {
            return new CertificateChainModel(result);
        }
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        CertificateModel currentCertificate = certificate;
        chain.add(currentCertificate.getCertificate());
        while (!currentCertificate.isRootCertificate()) {
            currentCertificate = this.getSigningCertificate(currentCertificate);
            chain.add(currentCertificate.getCertificate());
        }
        result = chain.toArray(new X509Certificate[0]);
        return new CertificateChainModel(result);
    }

    public CertificateChainModel constructCertificateChain(String alias) throws KeyStoreException, MissingCertificateException {
        return this.constructCertificateChain(this.getCertificate(alias));
    }

    public Date getCreationDate(String alias) throws KeyStoreException {
        return this.keyStore.getCreationDate(alias);
    }

    public Key getKey(String name, char[] passwd) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.keyStore.getKey(name, passwd);
    }

    public boolean isCertificateEntry(String alias) throws KeyStoreException {
        return this.keyStore.isCertificateEntry(alias);
    }

    public boolean isKeyEntry(String alias) throws KeyStoreException {
        return this.keyStore.isKeyEntry(alias);
    }

    public void setCertificateEntry(String alias, CertificateModel certificate) throws KeyStoreException {
        boolean alreadyContained = this.keyStore.containsAlias(alias);
        this.keyStore.setCertificateEntry(alias, certificate.getCertificate());
        this.modified = true;
        if (alreadyContained) {
            this.fireEntryChanged(alias);
        } else {
            this.fireEntryAdded(alias);
        }
    }

    private void genericSetKeyEntry(String alias, Key key, char[] passphrase, Certificate[] chain) throws KeyStoreException {
        boolean alreadyContained = this.keyStore.containsAlias(alias);
        this.keyStore.setKeyEntry(alias, key, passphrase, chain);
        this.modified = true;
        if (alreadyContained) {
            this.fireEntryChanged(alias);
        } else {
            this.fireEntryAdded(alias);
        }
    }

    public void setKeyEntry(String alias, Key key, char[] password, X509Certificate[] chain) throws KeyStoreException {
        this.genericSetKeyEntry(alias, key, password, chain);
    }

    public int size() throws KeyStoreException {
        return this.keyStore.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyStoreListener(KeyStoreListener listener) {
        if (listener == null) {
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyStoreListener(KeyStoreListener listener) {
        if (listener == null) {
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireKeyStoreEvent(KeyStoreEvent event) {
        ArrayList copy;
        List list = this.listeners;
        synchronized (list) {
            copy = new ArrayList(this.listeners);
        }
        Iterator it = copy.iterator();
        block8: while (it.hasNext()) {
            KeyStoreListener current = (KeyStoreListener)it.next();
            switch (event.getType()) {
                case 1: {
                    current.entryAdded(event);
                    continue block8;
                }
                case 2: {
                    current.entryRemoved(event);
                    continue block8;
                }
                case 3: {
                    current.entryChanged(event);
                    continue block8;
                }
            }
            current.keyStoreChanged(event);
        }
    }

    protected void fireEntryAdded(String alias) {
        this.fireKeyStoreEvent(new KeyStoreEvent(this, 1, alias));
    }

    protected void fireEntryRemoved(String alias) {
        this.fireKeyStoreEvent(new KeyStoreEvent(this, 2, alias));
    }

    protected void fireEntryChanged(String alias) {
        this.fireKeyStoreEvent(new KeyStoreEvent(this, 3, alias));
    }

    protected void fireKeyStoreChanged() {
        this.fireKeyStoreEvent(new KeyStoreEvent(this, 4, null));
    }

    protected void fireKeyStoreSaved() {
        this.fireKeyStoreEvent(new KeyStoreEvent(this, 5, null));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

