/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.security;

import com.tryllian.are.security.KeyStoreModel;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Date;

public class KeyStoreEntry {
    private String alias;
    private KeyStoreModel keystore;

    public KeyStoreEntry(KeyStoreModel keystore, String alias) {
        this.keystore = keystore;
        this.alias = alias;
    }

    public X509Certificate getCertificate() throws KeyStoreException {
        return this.keystore.getCertificate(this.alias).getCertificate();
    }

    public boolean isKeyEntry() throws KeyStoreException {
        return this.keystore.isKeyEntry(this.alias);
    }

    public boolean isCertificateEntry() throws KeyStoreException {
        return this.keystore.isCertificateEntry(this.alias);
    }

    public Key getPrivateKey(char[] password) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        return this.keystore.getKey(this.alias, password);
    }

    public PublicKey getPublicKey() throws KeyStoreException {
        return this.getCertificate().getPublicKey();
    }

    public Date getCreationDate() throws KeyStoreException {
        return this.keystore.getCreationDate(this.alias);
    }
}

