/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.security;

import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;

public class KeyInfo {
    private static final Integer[] KEY_SIZES = new Integer[]{new Integer(512), new Integer(768), new Integer(1024)};
    private static final String[] KEYPAIR_ALGORITHM_NAMES = new String[]{"DSA", "RSA"};

    public static Integer[] getKeySizes() {
        return KEY_SIZES;
    }

    public static String[] getKeyPairAlgorithms() {
        return KEYPAIR_ALGORITHM_NAMES;
    }

    static String getSigningAlgorithm(PrivateKey key) throws NoSuchAlgorithmException {
        if (key instanceof RSAPrivateKey) {
            return "MD5WithRSAEncryption";
        }
        if (key instanceof DSAPrivateKey) {
            return "SHA1WithDSA";
        }
        throw new NoSuchAlgorithmException("No signature algorithm for key of type " + key.getClass().getName());
    }
}

