/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.security;

import java.security.Principal;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.jce.X509Principal;

public class DistinguishedNameModel {
    private X509Principal x509Principal;

    public DistinguishedNameModel(String commonName, String organization, String organizationalUnit, String country, String stateOrProvince, String locality) {
        Hashtable<DERObjectIdentifier, String> attributes = new Hashtable<DERObjectIdentifier, String>();
        attributes.put(X509Principal.CN, commonName);
        if (organization != null) {
            attributes.put(X509Principal.O, organization);
        }
        if (organizationalUnit != null) {
            attributes.put(X509Principal.OU, organizationalUnit);
        }
        if (country != null) {
            attributes.put(X509Principal.C, country);
        }
        if (stateOrProvince != null) {
            attributes.put(X509Principal.ST, stateOrProvince);
        }
        if (locality != null) {
            attributes.put(X509Principal.L, locality);
        }
        this.x509Principal = new X509Principal(attributes);
    }

    public DistinguishedNameModel(Principal principal) {
        if (principal == null) {
            throw new IllegalArgumentException("Principal can not be null");
        }
        this.x509Principal = new X509Principal(((Object)principal).toString());
    }

    public Principal getDistinguishedName() {
        return this.x509Principal;
    }

    private String getImpl(DERObjectIdentifier oid) {
        Vector oids = this.x509Principal.getOIDs();
        Vector values = this.x509Principal.getValues();
        for (int i = 0; i < oids.size() && i < values.size(); ++i) {
            if (!oid.equals(oids.get(i))) continue;
            return (String)values.get(i);
        }
        return null;
    }

    public String getCommonName() {
        return this.getImpl(X509Principal.CN);
    }

    public String getOrganization() {
        return this.getImpl(X509Principal.O);
    }

    public String getOrganizationalUnit() {
        return this.getImpl(X509Principal.OU);
    }

    public String getCountry() {
        return this.getImpl(X509Principal.C);
    }

    public String getStateOrProvince() {
        return this.getImpl(X509Principal.ST);
    }

    public String getLocality() {
        return this.getImpl(X509Principal.L);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        DistinguishedNameModel other = (DistinguishedNameModel)o;
        return this.x509Principal.equals((Object)other.x509Principal);
    }

    X509Principal getImplPrincipal() {
        return this.x509Principal;
    }

    public int hashCode() {
        return this.x509Principal.hashCode();
    }

    public String toString() {
        return this.x509Principal.toString();
    }
}

