/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.security;

import com.tryllian.are.security.CertificateChainModel;
import com.tryllian.are.security.DistinguishedNameModel;
import com.tryllian.are.security.KeyInfo;
import com.tryllian.are.security.KeyStoreModel;
import com.tryllian.are.security.MissingCertificateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertificateModel
implements Cloneable {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tryllian$are$security$CertificateModel == null ? (class$com$tryllian$are$security$CertificateModel = CertificateModel.class$("com.tryllian.are.security.CertificateModel")) : class$com$tryllian$are$security$CertificateModel));
    static final String CERTIFICATE_TYPE = "X.509";
    private X509Certificate certificate;
    private X509V3CertificateGenerator certGenerator;
    static /* synthetic */ Class class$com$tryllian$are$security$CertificateModel;

    public CertificateModel() {
        this.initialize();
    }

    public CertificateModel(X509Certificate certificate) throws CertificateException {
        this.setCertificate(certificate);
    }

    public void initialize() {
        this.certGenerator = new X509V3CertificateGenerator();
    }

    public void read(InputStream is) throws IOException, CertificateException {
        try {
            CertificateFactory factory = CertificateFactory.getInstance(CERTIFICATE_TYPE, BouncyCastleProvider.PROVIDER_NAME);
            Certificate generatedCertificate = factory.generateCertificate(is);
            this.setCertificate((X509Certificate)generatedCertificate);
        }
        catch (NoSuchProviderException nspe) {
            LOG.fatal((Object)"Missing cryptographic provider", (Throwable)nspe);
        }
    }

    public void write(OutputStream os) throws IOException {
        try {
            os.write(this.certificate.getEncoded());
        }
        catch (CertificateEncodingException cee) {
            throw new IOException(cee.getMessage());
        }
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate cert) throws CertificateException {
        this.certificate = cert;
    }

    public void setIssuerDN(DistinguishedNameModel issuer) {
        this.certGenerator.setIssuerDN((X509Name)issuer.getImplPrincipal());
    }

    public void setPublicKey(PublicKey key) throws InvalidKeyException {
        this.certGenerator.setPublicKey(key);
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.certGenerator.setSerialNumber(serialNumber);
    }

    public void setSubjectDN(DistinguishedNameModel subject) {
        this.certGenerator.setSubjectDN((X509Name)subject.getImplPrincipal());
    }

    public void setValidity(Date validNotBefore, Date validNotAfter) {
        this.certGenerator.setNotBefore(validNotBefore);
        this.certGenerator.setNotAfter(validNotAfter);
    }

    public void sign(PrivateKey key) throws NoSuchAlgorithmException, InvalidKeyException, CertificateException {
        try {
            this.certGenerator.setSignatureAlgorithm(KeyInfo.getSigningAlgorithm(key));
            this.setCertificate(this.certGenerator.generateX509Certificate(key));
        }
        catch (SignatureException se) {
            throw new CertificateException(se.getMessage());
        }
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.certificate.verify(key);
    }

    public boolean verify(KeyStoreModel keystore) throws CertificateException, MissingCertificateException, KeyStoreException, NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        CertificateChainModel chain = keystore.constructCertificateChain(this);
        return chain.verify(keystore, null);
    }

    public boolean verify(KeyStoreModel keystore, KeyStoreModel revokedKS) throws CertificateException, MissingCertificateException, KeyStoreException, NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        CertificateChainModel chain = keystore.constructCertificateChain(this);
        return chain.verify(keystore, revokedKS);
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.certificate.checkValidity();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            CertificateModel clone = (CertificateModel)super.clone();
            byte[] certBytes = this.certificate.getEncoded();
            ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
            CertificateFactory certFac = CertificateFactory.getInstance(CERTIFICATE_TYPE);
            Certificate cloneCert = certFac.generateCertificate(bais);
            if (!(cloneCert instanceof X509Certificate)) {
                throw new CloneNotSupportedException();
            }
            clone.setCertificate((X509Certificate)cloneCert);
            return clone;
        }
        catch (CertificateException ce) {
            throw new CloneNotSupportedException(ce.getMessage());
        }
    }

    public DistinguishedNameModel getIssuerDN() {
        return this.certificate == null ? null : new DistinguishedNameModel(this.certificate.getIssuerDN());
    }

    public boolean[] getIssuerUniqueID() {
        return this.certificate.getIssuerUniqueID();
    }

    public Date getNotAfter() {
        return this.certificate.getNotAfter();
    }

    public Date getNotBefore() {
        return this.certificate.getNotBefore();
    }

    public PublicKey getPublicKey() {
        return this.certificate.getPublicKey();
    }

    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber();
    }

    public String getSigAlgName() {
        return this.certificate.getSigAlgName();
    }

    public String getSigAlgOID() {
        return this.certificate.getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this.certificate.getSigAlgParams();
    }

    public byte[] getSignature() {
        return this.certificate.getSignature();
    }

    public DistinguishedNameModel getSubjectDN() {
        return this.certificate == null ? null : new DistinguishedNameModel(this.certificate.getSubjectDN());
    }

    public void setID(byte[] id) throws CertificateException {
        this.certGenerator.addExtension("1.3.6.1.4.1.9727.1", false, id);
    }

    public byte[] getID() {
        try {
            X509Certificate cert = this.certificate;
            byte[] rawDERExtension = cert.getExtensionValue("1.3.6.1.4.1.9727.1");
            if (rawDERExtension == null) {
                return null;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(rawDERExtension);
            ASN1InputStream ais = new ASN1InputStream((InputStream)bais);
            DERObject obj = ais.readObject();
            byte[] b = ((DEROctetString)obj).getOctets();
            if (b.length != 12) {
                bais = new ByteArrayInputStream(b);
                ais = new ASN1InputStream((InputStream)bais);
                obj = ais.readObject();
                b = ((DEROctetString)((DERSequence)obj).getObjectAt(1)).getOctets();
            }
            return b;
        }
        catch (Throwable t) {
            LOG.warn((Object)"Could not get ID from certificate", t);
            return null;
        }
    }

    public boolean[] getSubjectUniqueID() {
        return this.certificate.getSubjectUniqueID();
    }

    public int getVersion() {
        return this.certificate.getVersion();
    }

    public byte[] getFingerprint(String digestAlgorithm) throws NoSuchAlgorithmException {
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update(this.certificate.getEncoded());
            return md.digest();
        }
        catch (CertificateEncodingException cee) {
            return new byte[0];
        }
    }

    public boolean isRootCertificate() {
        DistinguishedNameModel subject = this.getSubjectDN();
        DistinguishedNameModel issuer = this.getIssuerDN();
        if (subject == null || issuer == null) {
            return false;
        }
        if (!subject.equals(issuer)) {
            return false;
        }
        return Arrays.equals(this.getIssuerUniqueID(), this.getSubjectUniqueID());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CertificateModel)) {
            return false;
        }
        return this.getCertificate().equals(((CertificateModel)obj).getCertificate());
    }

    public int hashCode() {
        return this.getCertificate().hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

