/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.security;

import com.tryllian.are.security.CertificateModel;
import com.tryllian.are.security.KeyStoreModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Properties;

public class CertificateLoader {
    private CertificateModel certificate;
    private PrivateKey privateKey;
    public static final String CONFIG_DIR_PROPERTY = "are.configdir";
    public static final String DEFAULT_PRIVATE_KEYSTORE = "habitat-private-keystore.dat";
    public static final String PROPERTY_PRIVATE_KEYSTORE = "messenger.security.private-keystore";
    public static final String PROPERTY_PRIVATE_KEYSTORE_PASSWORD = "messenger.security.private-keystore.password";
    public static final String PROPERTY_PRIVATE_KEYSTORE_ENTRY_ALIAS = "messenger.security.private-keystore.entry.alias";
    public static final String PROPERTY_PRIVATE_KEYSTORE_ENTRY_PASSWORD = "messenger.security.private-keystore.entry.password";
    public static final String PROPERTY_IS_SECURE = "messenger.http.secure";

    private File getConfigDir(Properties properties) throws IOException {
        File result;
        String configDir = properties.getProperty(CONFIG_DIR_PROPERTY);
        if (configDir == null) {
            configDir = System.getProperty(CONFIG_DIR_PROPERTY);
        }
        if (configDir == null) {
            configDir = System.getProperty("user.dir", "config");
        }
        if (!(result = new File(configDir)).exists()) {
            throw new IOException(result.getPath() + " does not exist!");
        }
        if (!result.isDirectory()) {
            throw new IOException(result.getPath() + " is not a directory");
        }
        return result;
    }

    public CertificateLoader(Properties properties) throws IOException, GeneralSecurityException {
        char[] entryPasswordArray;
        InputStream stream;
        if (properties == null) {
            properties = new Properties();
        }
        File configDir = this.getConfigDir(properties);
        String defaultKeystoreFile = "file:" + new File(configDir, DEFAULT_PRIVATE_KEYSTORE).getPath();
        String keystoreFile = properties.getProperty(PROPERTY_PRIVATE_KEYSTORE, defaultKeystoreFile);
        String password = properties.getProperty(PROPERTY_PRIVATE_KEYSTORE_PASSWORD);
        String alias = properties.getProperty(PROPERTY_PRIVATE_KEYSTORE_ENTRY_ALIAS, "habitat");
        String entryPassword = properties.getProperty(PROPERTY_PRIVATE_KEYSTORE_ENTRY_PASSWORD, password);
        boolean isSecure = Boolean.valueOf(properties.getProperty(PROPERTY_IS_SECURE, "false"));
        if (keystoreFile == null || keystoreFile.length() == 0) {
            throw new IOException("no keystore file given");
        }
        if (alias == null || alias.length() == 0) {
            throw new GeneralSecurityException("No alias specified for keystore " + keystoreFile + "; cannot obtain certificate");
        }
        KeyStoreModel keystore = KeyStoreModel.getInstance();
        try {
            stream = new URL(keystoreFile).openStream();
        }
        catch (IOException ioe) {
            if (isSecure) {
                throw new IOException("Could not read " + keystoreFile + "; but secure https communcation was desired");
            }
            this.certificate = null;
            this.privateKey = null;
            return;
        }
        char[] passwordArray = password == null || password.length() == 0 ? null : password.toCharArray();
        try {
            keystore.load(stream, passwordArray);
        }
        catch (IOException ioe) {
            if (isSecure) {
                throw ioe;
            }
            this.certificate = null;
            this.privateKey = null;
            return;
        }
        this.certificate = keystore.getCertificate(alias);
        if (this.certificate == null) {
            throw new IOException("Could not load certificate with alias " + alias);
        }
        char[] cArray = entryPasswordArray = entryPassword == null || entryPassword.length() == 0 ? passwordArray : entryPassword.toCharArray();
        if (isSecure) {
            this.privateKey = (PrivateKey)keystore.getKey(alias, entryPasswordArray);
            if (this.privateKey == null) {
                throw new IOException("Could not load private key with alias " + alias);
            }
        }
    }

    public CertificateModel getHabitatCertificate() {
        return this.certificate;
    }

    public PrivateKey getHabitatPrivateKey() {
        return this.privateKey;
    }
}

