/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.security;

import com.tryllian.are.security.CertificateModel;
import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import tryllian.util.encode.Base64;

public class CertificateConverter {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tryllian$are$security$CertificateConverter == null ? (class$com$tryllian$are$security$CertificateConverter = CertificateConverter.class$("com.tryllian.are.security.CertificateConverter")) : class$com$tryllian$are$security$CertificateConverter));
    static /* synthetic */ Class class$com$tryllian$are$security$CertificateConverter;

    private CertificateConverter() {
    }

    public static String encode(X509Certificate certificate) {
        try {
            return Base64.encode(certificate.getEncoded());
        }
        catch (NullPointerException npe) {
            return "CERTIFICATE NOT AVAILABLE.";
        }
        catch (CertificateEncodingException cee) {
            return "CERTIFICATE NOT AVAILABLE.";
        }
    }

    public static X509Certificate decode(String certificate) {
        byte[] certBytes = null;
        try {
            certBytes = Base64.decode(certificate);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509", BouncyCastleProvider.PROVIDER_NAME);
            Certificate generatedCertificate = factory.generateCertificate(bais);
            return (X509Certificate)generatedCertificate;
        }
        catch (CertificateException ce2) {
            LOG.error((Object)"Could not read certificate", (Throwable)ce2);
            return null;
        }
        catch (NoSuchProviderException nspe) {
            LOG.error((Object)"Missing cryptographic provider", (Throwable)nspe);
            return null;
        }
    }

    public static byte[] getID(X509Certificate certificate) {
        try {
            CertificateModel cm = new CertificateModel(certificate);
            return cm.getID();
        }
        catch (CertificateException ce) {
            return null;
        }
    }

    public static byte[] getID(String certificate) {
        try {
            CertificateModel cm = new CertificateModel(CertificateConverter.decode(certificate));
            return cm.getID();
        }
        catch (CertificateException ce) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

