/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.security;

import com.tryllian.are.security.CertificateModel;
import com.tryllian.are.security.KeyStoreModel;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class CertificateChainModel {
    private List chain = new ArrayList();

    public CertificateChainModel() {
    }

    public CertificateChainModel(X509Certificate[] chain) {
        this();
        this.setChain(chain);
    }

    public CertificateChainModel(CertificateModel[] chain) {
        this();
        this.setChain(chain);
    }

    public boolean verify(KeyStoreModel keystore, KeyStoreModel revokedKS) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        X509Certificate[] certificateChain = this.getChain();
        X509Certificate[] trusted = keystore.getCertificates();
        HashSet<X509Certificate> trustedCertificates = new HashSet<X509Certificate>(Arrays.asList(trusted));
        HashSet<Object> revokedCertificates = new HashSet();
        if (revokedKS != null) {
            X509Certificate[] revoked = revokedKS.getCertificates();
            revokedCertificates = new HashSet<X509Certificate>(Arrays.asList(revoked));
        }
        for (int i = 0; i < certificateChain.length; ++i) {
            X509Certificate current = certificateChain[i];
            X509Certificate parent = i + 1 == certificateChain.length ? current : certificateChain[i + 1];
            if (revokedCertificates.contains(current)) {
                return false;
            }
            current.checkValidity();
            current.verify(parent.getPublicKey());
            if (!trustedCertificates.contains(current)) continue;
            return true;
        }
        return false;
    }

    public void setChain(X509Certificate[] chain) {
        this.chain = Arrays.asList(chain);
    }

    public void setChain(CertificateModel[] chain) {
        X509Certificate[] x509Chain = new X509Certificate[chain.length];
        for (int i = 0; i < chain.length; ++i) {
            x509Chain[i] = chain[i].getCertificate();
        }
        this.setChain(x509Chain);
    }

    public X509Certificate[] getChain() {
        return (X509Certificate[])this.chain.toArray();
    }

    public void addCertificate(CertificateModel model) {
        this.addCertificate(model.getCertificate());
    }

    public void addCertificate(X509Certificate certificate) {
        this.chain.add(0, certificate);
    }
}

