/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.core;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class TaskScheduler {
    private static Timer timer;
    private static Set tasks;

    public static synchronized void schedule(TimerTask task, long delay) {
        if (timer != null) {
            timer.schedule(task, delay);
        } else {
            tasks.add(new ScheduledTask(task, delay));
        }
    }

    public static synchronized void schedule(TimerTask task, Date date) {
        long delay = date.getTime() - System.currentTimeMillis();
        TaskScheduler.schedule(task, delay > 0L ? delay : 0L);
    }

    public static synchronized void schedule(TimerTask task, long delay, long period) {
        if (timer != null) {
            timer.schedule(task, delay, period);
        } else {
            tasks.add(new ScheduledTask(task, delay, period));
        }
    }

    public static synchronized void schedule(TimerTask task, Date date, long period) {
        long delay = date.getTime() - System.currentTimeMillis();
        TaskScheduler.schedule(task, delay > 0L ? delay : 0L, period);
    }

    public static synchronized void initialize() {
        if (timer != null) {
            return;
        }
        timer = new Timer();
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            ScheduledTask st = (ScheduledTask)it.next();
            try {
                if (st.period == -1L) {
                    timer.schedule(st.task, st.delay);
                    continue;
                }
                timer.schedule(st.task, st.delay, st.period);
            }
            catch (IllegalArgumentException iae) {
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown() {
        if (timer == null) {
            return;
        }
        final Timer t = timer;
        timer = null;
        final Object o = new Object();
        t.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                t.cancel();
                Object object = o;
                synchronized (object) {
                    o.notify();
                }
            }
        }, 1L);
        try {
            Object object = o;
            synchronized (object) {
                o.wait(5000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        t.cancel();
    }

    static {
        tasks = new HashSet();
    }

    private static class ScheduledTask {
        final TimerTask task;
        final long delay;
        final long period;

        ScheduledTask(TimerTask task, long delay) {
            this.task = task;
            this.delay = delay;
            this.period = -1L;
        }

        ScheduledTask(TimerTask task, long delay, long period) {
            this.task = task;
            this.delay = delay;
            this.period = period;
        }
    }
}

