/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.common.serialization;

import com.tryllian.are.common.serialization.ClassLoaderInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import tryllian.util.encode.Base64;

public class SerializationHelper {
    public static String serializeObject(Object o) throws IOException {
        return Base64.encode(SerializationHelper.serializeToBytes(o));
    }

    public static byte[] serializeToBytes(Object o) throws IOException {
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream(10240);
        ObjectOutputStream serializer = new ObjectOutputStream(dataOut);
        serializer.writeObject(o);
        serializer.close();
        return dataOut.toByteArray();
    }

    public static Object deserializeObject(byte[] bytes, ClassLoader loader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream dataIn = new ByteArrayInputStream(bytes);
        ClassLoaderInputStream deserializer = new ClassLoaderInputStream(dataIn, loader);
        Object o = deserializer.readObject();
        deserializer.close();
        return o;
    }

    public static Object deserializeObject(String s, ClassLoader loader) throws IOException, ClassNotFoundException {
        byte[] objectBytes = Base64.decode(s);
        return SerializationHelper.deserializeObject(objectBytes, loader);
    }
}

