/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.common;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class WeakCache {
    private WeakHashMap map = new WeakHashMap();
    private ReferenceQueue queue = new ReferenceQueue();

    public synchronized void put(Object key, Object val) {
        this.cleanup();
        this.map.put(key, new WeakReference<Object>(val, this.queue));
    }

    public synchronized Object get(Object key) {
        this.cleanup();
        Reference ref = (Reference)this.map.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    public synchronized int size() {
        this.cleanup();
        return this.map.size();
    }

    public synchronized String toString() {
        StringBuffer ret = new StringBuffer("WeakCache contents:\n");
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            WeakReference ref = (WeakReference)entry.getValue();
            Object obj = ref.get();
            if (obj == null) continue;
            ret.append(obj.toString());
            ret.append('\n');
        }
        return ret.toString();
    }

    private void cleanup() {
        if (this.queue.poll() == null) {
            return;
        }
        while (this.queue.poll() != null) {
        }
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            WeakReference ref = (WeakReference)entry.getValue();
            if (ref.get() != null) continue;
            i.remove();
        }
    }
}

