/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.common;

import java.io.InterruptedIOException;

public class Queue {
    protected Object[] items;
    protected int head = 0;
    protected int tail = 0;
    protected boolean queueEmpty = true;
    protected String name;
    static final float capacityFactor = 1.5f;

    public Queue() {
        this("");
    }

    public Queue(int size) {
        this(size, "");
    }

    public Queue(String name) {
        this(10, name);
    }

    public Queue(int size, String name) {
        if (size == 0) {
            size = 1;
        }
        this.items = new Object[size];
        this.name = name;
    }

    public synchronized void enter(Object o) {
        if (this.head == this.tail && !this.queueEmpty) {
            this.extend();
        }
        this.items[this.head++] = o;
        if (this.head >= this.items.length) {
            this.head = 0;
        }
        this.queueEmpty = false;
        this.notify();
    }

    public synchronized Object retrieve(long wait) throws InterruptedException, InterruptedIOException {
        while (this.queueEmpty) {
            if (wait != -1L) {
                if (wait != 0L) {
                    this.wait(wait);
                }
                if (!this.queueEmpty) continue;
                throw new InterruptedIOException("Timeout occurred");
            }
            this.wait();
        }
        Object i = this.items[this.tail];
        this.items[this.tail] = null;
        ++this.tail;
        if (this.tail >= this.items.length) {
            this.tail = 0;
        }
        if (this.tail == this.head) {
            this.queueEmpty = true;
        }
        return i;
    }

    public Object retrieve() {
        while (true) {
            try {
                return this.retrieve(-1L);
            }
            catch (InterruptedException ie) {
                continue;
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            break;
        }
    }

    public int getSize() {
        return this.items.length;
    }

    public String getName() {
        return this.name;
    }

    public synchronized int getRetrievable() {
        if (this.queueEmpty) {
            return 0;
        }
        if (this.head <= this.tail) {
            return this.items.length - this.tail + this.head;
        }
        return this.head - this.tail;
    }

    private void extend() {
        int newSize = (int)((float)this.items.length * 1.5f);
        if (newSize <= this.items.length) {
            ++newSize;
        }
        Object[] newItems = new Object[newSize];
        if (this.head <= this.tail) {
            System.arraycopy(this.items, 0, newItems, 0, this.head);
            System.arraycopy(this.items, this.tail, newItems, this.tail + (newItems.length - this.items.length), this.items.length - this.tail);
            this.tail += newItems.length - this.items.length;
        } else {
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        }
        this.items = newItems;
    }

    public String toString() {
        return this.getClass().getName() + "[name=\"" + this.getName() + "\"; retrievable=" + this.getRetrievable() + "; size=" + this.getSize() + "]";
    }
}

