/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.common;

import com.tryllian.are.common.IPGuesser;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class NetConfig {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tryllian$are$common$NetConfig == null ? (class$com$tryllian$are$common$NetConfig = NetConfig.class$("com.tryllian.are.common.NetConfig")) : class$com$tryllian$are$common$NetConfig));
    private static final Set DEFAULT_LOCAL_ADDRESSES = new HashSet<String>(Arrays.asList("127.0.0.1", "localhost", "localhost.localdomain"));
    private List localAddresses = new ArrayList(1);
    private List localHostNames = new ArrayList(1);
    private List localIPs = new ArrayList(1);
    static /* synthetic */ Class class$com$tryllian$are$common$NetConfig;

    public NetConfig(String hostnames) throws UnknownHostException {
        this.initializeLocalAddresses(hostnames);
        this.initializeLocalHostNames();
        this.initializeLocalIPs();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)this);
        }
    }

    public String getPrimaryHostName() {
        if (this.localHostNames.size() > 0) {
            return (String)this.localHostNames.get(0);
        }
        return null;
    }

    public List getHostNames() {
        return Collections.unmodifiableList(this.localHostNames);
    }

    public InetAddress getPrimaryInetAddress() {
        if (this.localAddresses.size() > 0) {
            return (InetAddress)this.localAddresses.get(0);
        }
        return null;
    }

    public List getInetAddresses() {
        return Collections.unmodifiableList(this.localAddresses);
    }

    public boolean isLocalAddress(String hostName) {
        if (hostName == null) {
            return false;
        }
        return DEFAULT_LOCAL_ADDRESSES.contains(hostName = hostName.toLowerCase()) || this.localHostNames.contains(hostName) || this.localIPs.contains(hostName) || this.dnsResolvesToLocal(hostName);
    }

    private boolean dnsResolvesToLocal(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            Iterator it = this.getInetAddresses().iterator();
            while (it.hasNext()) {
                InetAddress current = (InetAddress)it.next();
                if (!address.equals(current)) continue;
                return true;
            }
            return false;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("NetConfig[");
        this.writeHostNames(result);
        this.writeIPs(result);
        result.append("]");
        return result.toString();
    }

    private void writeHostNames(StringBuffer result) {
        if (this.localHostNames.size() == 0) {
            result.append("No known hostnames\n");
            return;
        }
        if (this.localHostNames.size() == 1) {
            result.append("NetConfig Hostname:     ");
        } else {
            result.append("NetConfig Hostnames:    ");
        }
        Iterator it = this.localHostNames.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append("\n");
    }

    private void writeIPs(StringBuffer result) {
        if (this.localIPs.size() == 0) {
            result.append("No known IP addresses\n");
            return;
        }
        if (this.localIPs.size() == 1) {
            result.append("NetConfig IP Address:   ");
        } else {
            result.append("NetConfig IP Addresses: ");
        }
        Iterator it = this.localIPs.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append("\n");
    }

    private static boolean checkSanity(InetAddress localHost) throws UnknownHostException {
        boolean ok = true;
        String primaryIP = localHost.getHostAddress();
        String primaryHost = localHost.getHostName();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Primary name of this host: " + primaryHost));
            LOG.info((Object)("Primary address of this host: " + primaryIP));
        }
        InetAddress resolvedHost = InetAddress.getByName(primaryHost);
        String resolvedHostIP = resolvedHost.getHostAddress();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(primaryHost + " resolves to " + resolvedHostIP));
        }
        if (!primaryIP.equalsIgnoreCase(resolvedHostIP)) {
            LOG.warn((Object)"Resolved primary hostname does not match primary IP address");
            ok = false;
        }
        InetAddress resolvedIP = InetAddress.getByName(primaryIP);
        String resolvedIPIP = resolvedIP.getHostName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(primaryIP + " resolves to " + resolvedIPIP));
        }
        if (!primaryHost.equalsIgnoreCase(resolvedIPIP)) {
            ok = false;
            LOG.warn((Object)"Resolved primary IP address does not match primary host name");
            int index = resolvedIPIP.indexOf(46);
            if (index != -1 && primaryHost.equalsIgnoreCase(resolvedIPIP = resolvedIPIP.substring(0, index))) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"However, the host part of the domain name seems to be OK");
                }
                ok = true;
            }
        }
        if (primaryHost.equalsIgnoreCase("localhost") || primaryHost.equalsIgnoreCase("localhost.localdomain") || primaryHost.equalsIgnoreCase("127.0.0.1")) {
            LOG.warn((Object)"Primary host name should not be localhost,  localhost.localdomain or 127.0.0.1");
            ok = false;
        }
        if (primaryIP.equalsIgnoreCase("127.0.0.1")) {
            LOG.warn((Object)"Primary IP address should not be 127.0.0.1");
            ok = false;
        }
        if (ok) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Hostname and IP address look fine.");
                LOG.info((Object)"If network problems occur, it may be that multicast is disabled on this interface,");
                LOG.info((Object)"or that you are running java 1.4 or later  on an IPv6 enabled network interface");
            }
        } else {
            LOG.warn((Object)"Potential problem detected");
            LOG.warn((Object)"Consult the developers guide");
        }
        return ok;
    }

    private void initializeLocalAddresses(String hostnames) throws UnknownHostException {
        boolean localHostWorked = false;
        boolean propertiesGiven = false;
        ArrayList<InetAddress> unqualifiedAddresses = new ArrayList<InetAddress>();
        if (hostnames != null && !"".equals(hostnames) && !"localhost".equals(hostnames)) {
            StringTokenizer tok = new StringTokenizer(hostnames, ", \t");
            while (tok.hasMoreElements()) {
                propertiesGiven = true;
                String hostname = ((String)tok.nextElement()).toLowerCase();
                try {
                    this.localHostNames.add(hostname);
                    InetAddress[] propertyAddresses = InetAddress.getAllByName(hostname);
                    unqualifiedAddresses.addAll(Arrays.asList(propertyAddresses));
                }
                catch (UnknownHostException uhe) {
                    LOG.warn((Object)("Could not lookup local hostname: " + hostname), (Throwable)uhe);
                }
            }
            if (unqualifiedAddresses.size() == 0) {
                throw new UnknownHostException("Could not determine any valid IP address from the list '" + hostnames + "'");
            }
        }
        if (!propertiesGiven) {
            InetAddress localHost = null;
            try {
                localHost = InetAddress.getLocalHost();
                if (NetConfig.checkSanity(localHost)) {
                    unqualifiedAddresses.add(localHost);
                    localHostWorked = true;
                }
            }
            catch (UnknownHostException noLocalHost) {
                // empty catch block
            }
            if (!localHostWorked) {
                InetAddress guessedIP = IPGuesser.ipGuess("224.0.0.3", 6789);
                if (guessedIP != null) {
                    unqualifiedAddresses.add(guessedIP);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Guessed my IP: " + guessedIP.getHostAddress()));
                        LOG.info((Object)"But this computer has a defective network configuration.");
                    }
                } else {
                    throw new UnknownHostException("Could not determine your localhost automatically");
                }
            }
        }
        Iterator i = unqualifiedAddresses.iterator();
        while (i.hasNext()) {
            InetAddress current = (InetAddress)i.next();
            if (!propertiesGiven) {
                current = this.fullyQualify(current);
            }
            if (this.localAddresses.contains(current)) continue;
            this.localAddresses.add(current);
        }
    }

    public InetAddress fullyQualify(InetAddress address) throws UnknownHostException {
        if (NetConfig.hasDottedDecimalName(address)) {
            return address;
        }
        return InetAddress.getByName(address.getHostAddress());
    }

    private void initializeLocalHostNames() {
        Iterator it = this.localAddresses.iterator();
        while (it.hasNext()) {
            InetAddress current = (InetAddress)it.next();
            String name = current.getHostName().toLowerCase();
            if (this.localHostNames.contains(name)) continue;
            this.localHostNames.add(name);
        }
    }

    public static boolean hasDottedDecimalName(InetAddress address) {
        return NetConfig.isDottedDecimal(address.getHostName());
    }

    public static boolean isDottedDecimal(String hostname) {
        int dots = 0;
        int count = 0;
        for (int i = 0; i < hostname.length(); ++i) {
            char ch = hostname.charAt(i);
            if (ch == '.') {
                if (count == 0) {
                    return false;
                }
                count = 0;
                ++dots;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                if (++count <= 3) continue;
                return false;
            }
            return false;
        }
        return dots == 3 && count > 0;
    }

    private void initializeLocalIPs() {
        Iterator it = this.localAddresses.iterator();
        while (it.hasNext()) {
            InetAddress current = (InetAddress)it.next();
            this.localIPs.add(current.getHostAddress());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

