/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.common;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class IPGuesser {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tryllian$are$common$IPGuesser == null ? (class$com$tryllian$are$common$IPGuesser = IPGuesser.class$("com.tryllian.are.common.IPGuesser")) : class$com$tryllian$are$common$IPGuesser));
    private static final int MAX_ATTEMPTS = 8;
    private static final int WAIT_SEND = 400;
    private static final int WAIT_RECEIVE = 200;
    static /* synthetic */ Class class$com$tryllian$are$common$IPGuesser;

    private static void send(byte[] b, int port, String multicastIP) throws SocketException, IOException {
        byte[] buf = b;
        DatagramSocket ssock = new DatagramSocket();
        try {
            InetAddress address = InetAddress.getByName(multicastIP);
            DatagramPacket packet = new DatagramPacket(buf, buf.length, address, port);
            System.err.print(".");
            ssock.send(packet);
        }
        catch (UnknownHostException uhe) {
            LOG.warn((Object)"Not a valid multicast?", (Throwable)uhe);
        }
    }

    public static InetAddress ipGuess(String multicastIP, int port) {
        InetAddress myHost = null;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Attempting to guess IP-address ");
        }
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            DataOutputStream b = new DataOutputStream(buf);
            b.writeDouble(Math.random());
            b.writeDouble(Math.random());
            Receiver finder = new Receiver(b.toString().getBytes("UTF-8"), port, multicastIP);
            Thread seeker = new Thread(finder);
            seeker.start();
            while (!finder.found() && seeker.isAlive()) {
                IPGuesser.send(b.toString().getBytes("UTF-8"), port, multicastIP);
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException ie) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Interrupted", (Throwable)ie);
                }
            }
            if (finder.found()) {
                myHost = finder.who();
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Could not guess IP address", (Throwable)ioe);
        }
        return myHost;
    }

    public static void main(String[] args) {
        try {
            String address = "224.0.0.3";
            int port = 6789;
            if (args.length >= 1) {
                address = args[0];
            }
            if (args.length >= 2) {
                try {
                    port = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Guessing through " + address + ":" + port));
                LOG.info((Object)("Found: " + IPGuesser.ipGuess(address, port)));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not guess IP address", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Receiver
    implements Runnable {
        private DatagramPacket rec;
        private MulticastSocket mySocket = null;
        private InetAddress me = null;
        private byte[] expect;

        protected Receiver(byte[] bytesExpected, int port, String multicastIP) {
            this.expect = bytesExpected;
            try {
                this.mySocket = new MulticastSocket(port);
                this.mySocket.joinGroup(InetAddress.getByName(multicastIP));
                this.mySocket.setSoTimeout(200);
            }
            catch (UnknownHostException uhe) {
                LOG.warn((Object)"Cannot guess IP address", (Throwable)uhe);
            }
            catch (IOException ioe) {
                LOG.warn((Object)"Cannot guess IP address", (Throwable)ioe);
            }
        }

        public void run() {
            int attempts = 0;
            while (this.me == null && attempts++ <= 8) {
                byte[] b = new byte[this.expect.length];
                this.rec = new DatagramPacket(b, b.length);
                try {
                    this.mySocket.receive(this.rec);
                    if (Arrays.equals(b, this.expect)) {
                        System.err.println("!");
                        this.me = this.rec.getAddress();
                        return;
                    }
                    System.err.print("*");
                }
                catch (InterruptedIOException iioe) {
                    System.err.print("_");
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Could not guess IP address", (Throwable)ioe);
                }
            }
            System.err.println("?");
        }

        protected boolean found() {
            return this.me != null;
        }

        protected InetAddress who() {
            return this.me;
        }
    }
}

