/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.common;

public class HexConverter {
    static final char[] digits = "0123456789abcdef".toCharArray();
    static final int NIBBLES_IN_LONG = 16;
    static final int NIBBLES_IN_INT = 8;
    static final int BITS_IN_NIBBLE = 4;
    static final int MASK_FOR_NIBBLE = 15;

    public static String toHexString(byte[] array) {
        return HexConverter.toHexString(array, 0, array.length);
    }

    public static String toHexString(byte[] array, int offset, int length) {
        char[] string = new char[2 * length];
        for (int arrayindex = 0; arrayindex < length; ++arrayindex) {
            byte aByte = array[arrayindex + offset];
            string[arrayindex * 2] = digits[aByte >>> 4 & 0xF];
            string[arrayindex * 2 + 1] = digits[aByte & 0xF];
        }
        return new String(string);
    }

    public static byte[] toByteArray(String hexString) {
        return HexConverter.toByteArray(hexString, 0, hexString.length());
    }

    public static byte[] toByteArray(String hexString, int offset, int length) {
        byte[] resultBytes = new byte[length / 2];
        for (int i = 0; i < length / 2; ++i) {
            int highNibble = HexConverter.digit(hexString.charAt(i * 2 + offset));
            int lowNibble = HexConverter.digit(hexString.charAt(i * 2 + 1 + offset));
            resultBytes[i] = (byte)(highNibble << 4 | lowNibble);
        }
        return resultBytes;
    }

    public static void toHexString(int value, char[] buffer, int offset) {
        int sindex = 7;
        while (sindex >= 0) {
            buffer[sindex + offset] = digits[value & 0xF];
            --sindex;
            value >>>= 4;
        }
    }

    public static String toHexString(int value) {
        char[] string = new char[8];
        HexConverter.toHexString(value, string, 0);
        return new String(string);
    }

    public static void toHexString(long value, char[] buffer, int offset) {
        int sindex = 15;
        while (sindex >= 0) {
            buffer[sindex + offset] = digits[(int)(value & 0xFL)];
            --sindex;
            value >>>= 4;
        }
    }

    public static String toHexString(long value) {
        char[] string = new char[16];
        HexConverter.toHexString(value, string, 0);
        return new String(string);
    }

    public static int toInteger(String value) {
        return HexConverter.toInteger(value, 0);
    }

    public static long toLong(String value) {
        return HexConverter.toLong(value, 0);
    }

    public static int toInteger(String value, int offset) {
        int result = 0;
        if (value.length() - offset < 8) {
            throw new IllegalArgumentException("Hex string must have 8 hex digits left after offset. (" + (value.length() - offset) + " left)");
        }
        for (int vindex = 0; vindex < 8; ++vindex) {
            result <<= 4;
            result |= HexConverter.digit(value.charAt(offset + vindex));
        }
        return result;
    }

    public static long toLong(String value, int offset) {
        long result = 0L;
        if (value.length() - offset < 16) {
            throw new IllegalArgumentException("Hex string must have 16 hex digits left after offset. (" + (value.length() - offset) + " left)");
        }
        for (int vindex = 0; vindex < 16; ++vindex) {
            result <<= 4;
            result |= (long)HexConverter.digit(value.charAt(offset + vindex));
        }
        return result;
    }

    private static int digit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid character");
    }
}

