/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.common;

import com.tryllian.are.core.TaskScheduler;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;

public class FlushingMap
implements Map {
    private Map map;
    private long defaultTimeout;

    public FlushingMap(Map map, long timeout) {
        this.map = map;
        this.defaultTimeout = timeout;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(long time) {
        this.defaultTimeout = time;
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public synchronized boolean containsValue(Object value) {
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            FlushingValue entry = (FlushingValue)i.next();
            if (!value.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public synchronized Set entrySet() {
        return this.map.entrySet();
    }

    public synchronized boolean equals(Object o) {
        if (o instanceof FlushingMap) {
            return ((Object)this.map).equals(((FlushingMap)o).map);
        }
        return false;
    }

    public synchronized Object get(Object key) {
        FlushingValue value = (FlushingValue)this.map.get(key);
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    public synchronized int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized Set keySet() {
        return this.map.keySet();
    }

    public synchronized Object put(Object key, Object value) {
        this.cancelFlush(key);
        return this.map.put(key, new FlushingValue(key, value, this.defaultTimeout));
    }

    public synchronized boolean mark(Object key) {
        FlushingValue flushingValue = (FlushingValue)this.map.get(key);
        if (flushingValue != null && flushingValue.cancel()) {
            FlushingValue copy = new FlushingValue(key, flushingValue.getValue(), this.defaultTimeout);
            this.map.put(key, copy);
            return true;
        }
        return false;
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException("putAll(Map) not implemented by FlushingMap");
    }

    public synchronized Object remove(Object key) {
        FlushingValue flushingValue = (FlushingValue)this.map.remove(key);
        if (flushingValue != null && flushingValue.cancel()) {
            return flushingValue.getValue();
        }
        return null;
    }

    public synchronized int size() {
        return this.map.size();
    }

    public Collection values() {
        throw new UnsupportedOperationException("values() not implemented in FlushingMap");
    }

    private void cancelFlush(Object key) {
        FlushingValue value = (FlushingValue)this.map.get(key);
        if (value != null) {
            value.cancel();
        }
    }

    private class FlushingValue
    extends TimerTask {
        private final Object key;
        private final Object value;

        public FlushingValue(Object key, Object value, long timeout) {
            this.value = value;
            this.key = key;
            TaskScheduler.schedule((TimerTask)this, timeout);
        }

        public void run() {
            FlushingMap.this.map.remove(this.key);
            if (this.value instanceof Flushable) {
                ((Flushable)this.value).run();
            }
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class Flushable {
        private final Object flush;

        public Flushable(Object flush) {
            this.flush = flush;
        }

        public Object getObject() {
            return this.flush;
        }

        public void run() {
        }
    }
}

