/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.common;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CaseInsensitiveStringMap
extends AbstractMap
implements Serializable {
    private SortedSet backend = new TreeSet();
    private transient Set entrySet;

    public CaseInsensitiveStringMap() {
    }

    public CaseInsensitiveStringMap(Map t) {
        this();
        this.putAll(t);
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return CaseInsensitiveStringMap.this.backend.iterator();
                }

                public int size() {
                    return CaseInsensitiveStringMap.this.backend.size();
                }
            };
        }
        return this.entrySet;
    }

    private CanonicalEntry getEntry(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        if (key == null) {
            return null;
        }
        String keyAsString = (String)key;
        CanonicalEntry lowestEntry = new CanonicalEntry(keyAsString, "");
        SortedSet<CanonicalEntry> tailSet = this.backend.tailSet(lowestEntry);
        if (tailSet.isEmpty()) {
            return null;
        }
        CanonicalEntry firstTailEntry = tailSet.first();
        if (firstTailEntry.hasKey(keyAsString)) {
            return firstTailEntry;
        }
        return null;
    }

    private CanonicalEntry putEntry(CanonicalEntry entry) {
        if (entry == null) {
            throw new IllegalStateException("Can not handle null-entries");
        }
        CanonicalEntry previous = this.getEntry(entry.getKey());
        if (previous == null) {
            this.backend.add(entry);
            return null;
        }
        if (entry.isIdentical(previous)) {
            return previous;
        }
        this.backend.remove(previous);
        this.backend.add(entry);
        return previous;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        if (value == null) {
            throw new NullPointerException("Null values are not allowed");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("Only String keys allowed");
        }
        if (!(value instanceof String)) {
            throw new ClassCastException("Only String values allowed");
        }
        CanonicalEntry entry = new CanonicalEntry((String)key, (String)value);
        CanonicalEntry previous = this.putEntry(entry);
        if (previous == null) {
            return null;
        }
        return previous.getValue();
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys not supported in this map");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("Key " + key + " is not a String");
        }
        CanonicalEntry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException("Null kets not supported in this map");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("Key " + key + " is not a String");
        }
        return this.getEntry(key) != null;
    }

    public Object remove(Object key) {
        CanonicalEntry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        this.backend.remove(entry);
        return entry.getValue();
    }

    public int size() {
        return this.backend.size();
    }

    public boolean isEmpty() {
        return this.backend.isEmpty();
    }

    public void clear() {
        this.backend.clear();
    }

    private class CanonicalEntry
    implements Map.Entry,
    Comparable,
    Serializable {
        private String canonicalKey;
        private String originalKey;
        private String value;

        public CanonicalEntry(String key, String value) {
            if (key == null) {
                throw new NullPointerException("Key can not be null");
            }
            this.originalKey = key;
            this.canonicalKey = key.toLowerCase();
            this.setValue(value);
        }

        public Object getKey() {
            return this.originalKey;
        }

        public boolean hasKey(String key) {
            if (key == null) {
                throw new NullPointerException("Can not compare with null-keys");
            }
            return key.toLowerCase().equals(this.canonicalKey);
        }

        public String getCanonicalKey() {
            return this.canonicalKey;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            if (!(value instanceof String)) {
                throw new ClassCastException("Values must be strings");
            }
            if (value == null) {
                throw new NullPointerException("Values can't be null");
            }
            String oldValue = this.value;
            this.value = (String)value;
            return oldValue;
        }

        public int hashCode() {
            return this.getCanonicalKey().hashCode() ^ this.getValue().hashCode();
        }

        public boolean isIdentical(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof CanonicalEntry)) {
                return false;
            }
            CanonicalEntry other = (CanonicalEntry)o;
            return this.originalKey.equals(other.originalKey) && this.value.equals(other.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            try {
                return this.compareTo(o) == 0;
            }
            catch (ClassCastException cce) {
                return false;
            }
        }

        public int compareTo(Object o) {
            CanonicalEntry other = (CanonicalEntry)o;
            int keyCompare = this.canonicalKey.compareTo(other.canonicalKey);
            if (keyCompare != 0) {
                return keyCompare;
            }
            return this.value.compareTo(other.value);
        }
    }
}

