/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class StatementReader
extends BufferedReader {
    private static final char SEMICOLON = ';';

    public StatementReader(Reader in) {
        super(in);
    }

    public String readStatement() throws IOException {
        StringBuffer result = new StringBuffer();
        boolean foundSemicolon = false;
        while (!foundSemicolon) {
            String line = this.readLine();
            if (line == null) {
                if (result.length() == 0) {
                    return null;
                }
                throw new IOException("Reached EOF while before reaching end of statement: " + result);
            }
            if (StatementReader.isComment(line = line.trim()) || StatementReader.isEmpty(line)) continue;
            if (line.indexOf(59) >= 0) {
                foundSemicolon = true;
                line = line.substring(0, line.indexOf(59));
            }
            result.append(' ');
            result.append(line);
        }
        return StatementReader.normalize(result);
    }

    private static boolean isComment(String line) {
        return line.startsWith("--");
    }

    private static boolean isEmpty(String line) {
        return line.length() == 0;
    }

    private static String normalize(StringBuffer buffer) {
        StringBuffer result = new StringBuffer(buffer.length());
        boolean trimming = false;
        for (int i = 0; i < buffer.length(); ++i) {
            char current = buffer.charAt(i);
            if (Character.isWhitespace(current)) {
                if (trimming) continue;
                trimming = true;
                result.append(' ');
                continue;
            }
            result.append(current);
            trimming = false;
        }
        return result.toString().trim();
    }
}

