/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.jdbc;

import com.tryllian.are.jdbc.ConnectionManager;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import tryllian.are.persistence.spi.PersistenceException;
import tryllian.are.persistence.spi.Transaction;

public class PooledConnection
implements Transaction {
    Connection connection = null;

    PooledConnection(Connection connection) throws SQLException {
        this.checkConnection(connection);
        this.connection = connection;
    }

    public void commit() throws PersistenceException {
        if (this.connection == null) {
            throw new PersistenceException("PooledConnection does not have a connection");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SQLException {
                    PooledConnection.this.connection.commit();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new PersistenceException("Could not commit.", (Throwable)pae.getException());
        }
    }

    public void rollback() throws PersistenceException {
        try {
            this.getConnection().rollback();
        }
        catch (SQLException sqle) {
            throw new PersistenceException("Could not rollback", (Throwable)sqle);
        }
    }

    public void close() throws PersistenceException {
        if (this.connection == null) {
            throw new PersistenceException("PooledConnection does not have a connection");
        }
        ConnectionManager.getInstance().restoreConnection(this.connection);
        this.connection = null;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            throw new SQLException("PooledConnection does not have a connection");
        }
        this.checkConnection(this.connection);
        return this.connection;
    }

    private void checkConnection(Connection connectionToCheck) throws SQLException {
        if (connectionToCheck.isClosed()) {
            throw new SQLException("Connection is closed.");
        }
    }
}

