/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.jdbc;

import com.tryllian.are.jdbc.ARLPlugin;
import com.tryllian.are.jdbc.AbstractPlugin;
import com.tryllian.are.jdbc.AgentPlugin;
import com.tryllian.are.jdbc.ConnectionManager;
import com.tryllian.are.jdbc.JNDIPlugin;
import com.tryllian.are.jdbc.PooledConnection;
import com.tryllian.are.jdbc.StatementReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Permission;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import tryllian.are.persistence.spi.ARLPersistencePlugin;
import tryllian.are.persistence.spi.AgentPersistencePlugin;
import tryllian.are.persistence.spi.JNDIPersistencePlugin;
import tryllian.are.persistence.spi.PersistenceException;
import tryllian.are.persistence.spi.PersistencePermission;
import tryllian.are.persistence.spi.PersistencePlugin;
import tryllian.are.persistence.spi.Transaction;

public class Plugin
extends AbstractPlugin
implements PersistencePlugin {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tryllian$are$jdbc$Plugin == null ? (class$com$tryllian$are$jdbc$Plugin = Plugin.class$("com.tryllian.are.jdbc.Plugin")) : class$com$tryllian$are$jdbc$Plugin));
    static final String PROPERTY_URL = "db.jdbc2.url";
    static final String PROPERTY_USER = "db.jdbc2.user";
    static final String PROPERTY_PASSWORD = "db.jdbc2.password";
    static final String PROPERTY_DRIVER = "db.jdbc2.driver";
    static final String PROPERTY_POOL_SIZE = "db.jdbc2.connections.max";
    static final String PROPERTY_POOL_TIMEOUT = "db.jdbc2.connections.timeout";
    private static final String ST_CLEAR_ALL = "DELETE FROM attributes;\nDELETE FROM arljars;\nDELETE FROM jarurl;\nDELETE FROM state;\nDELETE FROM agent;\nDELETE FROM arl;\nDELETE FROM jndibindings;\n";
    private Properties properties = null;
    private String user;
    private String passwd;
    private String url;
    private String driver;
    private ARLPersistencePlugin arlPlugin;
    private AgentPersistencePlugin agentPlugin;
    private JNDIPersistencePlugin jndiPlugin;
    static /* synthetic */ Class class$com$tryllian$are$jdbc$Plugin;

    public Plugin() {
        this.checkPermission("*");
        this.arlPlugin = new ARLPlugin();
        this.agentPlugin = new AgentPlugin();
        this.jndiPlugin = new JNDIPlugin();
    }

    public PooledConnection getConnection() throws SQLException, InterruptedException, InterruptedIOException {
        return ConnectionManager.getInstance().getPooledConnection();
    }

    public Transaction getTransaction() throws PersistenceException {
        try {
            return ConnectionManager.getInstance().getPooledConnection();
        }
        catch (Exception e) {
            throw new PersistenceException("Could not obtain transaction", (Throwable)e);
        }
    }

    private String getProperty(String property) {
        String result = this.properties.getProperty(property);
        if (result == null) {
            throw new IllegalArgumentException("Property " + property + " is not set");
        }
        return result;
    }

    private void initialize() throws PersistenceException {
        this.driver = this.getProperty(PROPERTY_DRIVER);
        this.user = this.getProperty(PROPERTY_USER);
        this.passwd = this.getProperty(PROPERTY_PASSWORD);
        this.url = this.getProperty(PROPERTY_URL);
        try {
            Class.forName(this.driver);
        }
        catch (Exception e) {
            throw new PersistenceException("Could not load JDBC driver ", (Throwable)e);
        }
        try {
            if (ConnectionManager.getInstance() == null) {
                ConnectionManager.initialize(this.properties);
            }
        }
        catch (SQLException sqle) {
            LOG.error((Object)"Could not initialize JDBC connection", (Throwable)sqle);
            throw new PersistenceException("Could not initialize connectionlayer", (Throwable)sqle);
        }
        String sqlFile = this.properties.getProperty("create-database-on-initialize");
        if (sqlFile != null) {
            try {
                this.runScript(new InputStreamReader((InputStream)new FileInputStream(sqlFile), "UTF-8"), null);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (PersistenceException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void cleanDB(Transaction t) throws PersistenceException {
        try {
            this.runScriptInTransaction(new StringReader(ST_CLEAR_ALL), t);
        }
        catch (IOException ioe) {
            throw new PersistenceException("Could not clear all tables", (Throwable)ioe);
        }
    }

    public void cleanDB(String habitatID, Transaction t) throws PersistenceException {
        this.agentPlugin.clear(t);
        this.arlPlugin.gc(t);
        String pref = "adk/" + habitatID;
        try {
            this.jndiPlugin.destroySubcontext("adk", habitatID, pref, t);
        }
        catch (NamingException ne) {
            throw new PersistenceException("Could not delete JNDI bindings in DB", (Throwable)ne);
        }
    }

    public void shutdown() throws PersistenceException {
        this.checkPermission("*");
        try {
            ConnectionManager.shutdown();
        }
        catch (SQLException sqle) {
            throw new PersistenceException("Cannot shutdown ConnectionManager", (Throwable)sqle);
        }
    }

    public void setProperties(Properties properties) throws IllegalArgumentException, PersistenceException {
        this.checkPermission("*");
        this.properties = properties;
        this.initialize();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public AgentPersistencePlugin getAgentPlugin() {
        this.checkPermission("persistAgents");
        return this.agentPlugin;
    }

    public ARLPersistencePlugin getARLPlugin() {
        this.checkPermission("persistARLs");
        return this.arlPlugin;
    }

    public JNDIPersistencePlugin getJNDIPlugin() {
        this.checkPermission("persistJNDI");
        return this.jndiPlugin;
    }

    private void checkPermission(String target) {
        PersistencePermission required = new PersistencePermission(target);
        AccessController.checkPermission((Permission)required);
    }

    public void gc(Transaction transaction) throws PersistenceException {
        this.checkPermission("*");
        this.getJNDIPlugin().gc(transaction);
        this.getARLPlugin().gc(transaction);
    }

    public void runScriptInTransaction(Reader in, Transaction t) throws PersistenceException, IOException {
        Connection conn;
        this.checkPermission("*");
        StatementReader reader = new StatementReader(in);
        try {
            conn = this.getConnection(t).getConnection();
        }
        catch (SQLException sqle) {
            throw new PersistenceException("Could not initialize connection to db", (Throwable)sqle);
        }
        this.processScript(reader, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(Reader in, String jdbcURL) throws PersistenceException, IOException {
        Connection conn;
        this.checkPermission("*");
        StatementReader reader = new StatementReader(in);
        String useUrl = jdbcURL != null ? jdbcURL : this.url;
        try {
            conn = DriverManager.getConnection(useUrl, this.user, this.passwd);
        }
        catch (SQLException sqle) {
            throw new PersistenceException("Could not initialize connection to db " + useUrl, (Throwable)sqle);
        }
        try {
            this.processScript(reader, conn);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                conn.close();
            }
            catch (SQLException sqle) {
                LOG.warn((Object)"Could not close connection", (Throwable)sqle);
            }
            throw throwable;
        }
        try {
            conn.close();
        }
        catch (SQLException sqle) {
            LOG.warn((Object)"Could not close connection", (Throwable)sqle);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processScript(StatementReader in, Connection conn) throws IOException, PersistenceException {
        void var6_6;
        String statement;
        int failedStatements = 0;
        int successfullStatements = 0;
        int totalStatements = 0;
        try {
            Statement s = conn.createStatement();
        }
        catch (SQLException sqle) {
            throw new PersistenceException("Could not connect to database", (Throwable)sqle);
        }
        while ((statement = in.readStatement()) != null) {
            ++totalStatements;
            try {
                var6_6.execute(statement);
                ++successfullStatements;
            }
            catch (SQLException sqle) {
                ++failedStatements;
                LOG.warn((Object)"Could not execute statement", (Throwable)sqle);
            }
        }
        try {
            var6_6.close();
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        if (failedStatements == 0 && successfullStatements == totalStatements) {
            return;
        }
        if (failedStatements == totalStatements) {
            throw new PersistenceException("All statements failed; could not initialize persistence environment");
        }
        LOG.fatal((Object)"Some SQL statements failed; check your log");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

