/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.jdbc;

import com.tryllian.are.core.habitat.IDManagement;
import com.tryllian.are.jdbc.AbstractPlugin;
import com.tryllian.are.jdbc.PooledConnection;
import com.tryllian.are.jndi.NamingConsistencyException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import tryllian.are.persistence.spi.JNDIPersistencePlugin;
import tryllian.are.persistence.spi.PersistenceException;
import tryllian.are.persistence.spi.Transaction;

public class JNDIPlugin
extends AbstractPlugin
implements JNDIPersistencePlugin {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tryllian$are$jdbc$JNDIPlugin == null ? (class$com$tryllian$are$jdbc$JNDIPlugin = JNDIPlugin.class$("com.tryllian.are.jdbc.JNDIPlugin")) : class$com$tryllian$are$jdbc$JNDIPlugin));
    private static final String CONTEXT_ROOT_OBJECT = "__ARE__ROOT__";
    private static final String ST_LOOKUP = "SELECT address FROM jndibindings WHERE context=? AND name=?";
    private static final String ST_BIND = "INSERT INTO jndibindings(context, name, address, protect) VALUES(?, ?, ?, ?)";
    private static final String ST_CLEAN = "DELETE FROM jndibindings WHERE context LIKE ? OR name=?";
    private static final String ST_DESTROY_SUBCONTEXT = "DELETE FROM jndibindings WHERE (context=? AND name=?)   OR (context=?)    OR (context LIKE ?)";
    private static final String ST_REBIND = "UPDATE jndibindings SET address=?, protect=? WHERE context=? AND name=?";
    private static final String ST_CHECK_PROTECTED_BINDING = "SELECT COUNT(address) FROM jndibindings WHERE context=? AND name=? AND protect=?";
    private static final String ST_CHECK_PROTECTED_CONTEXT = "SELECT COUNT(address) FROM jndibindings  WHERE (context LIKE ?)    AND (protect=?)";
    private static final String ST_UNBIND = "DELETE FROM jndibindings WHERE context=? AND name=?";
    private static final String ST_DROP_PROTECTION = "UPDATE jndibindings SET protect=? WHERE context=? AND name=?";
    private static final String ST_UNBIND_ALL = "DELETE FROM jndibindings WHERE address=?";
    private static final String ST_GET_BINDINGS = "SELECT name, address FROM jndibindings WHERE context=?";
    private static final String ST_GC_JNDI_NON_EXISTING_AGENTS = "DELETE FROM jndibindings WHERE context=?  AND name NOT IN            (SELECT agentid FROM agent)";
    private static final String ST_GC_JNDI_DEAD_END_ADDRESSES = "DELETE FROM jndibindings WHERE address like 'agent://%/tryllian/agents/%'   AND substr(address, length(address)-24) NOT IN        (SELECT name FROM jndibindings WHERE context=?)";
    private static final String CONTEXT_WILDCARD = "/%";
    private static final String COL_ADDRESS = "address";
    private static final String COL_NAME = "name";
    static /* synthetic */ Class class$com$tryllian$are$jdbc$JNDIPlugin;
    static /* synthetic */ Class class$javax$naming$Context;

    protected void wrapException(String message, Throwable t) throws NamingException {
        NamingException ne = new NamingException(message + ": " + t);
        ne.setRootCause(t);
        throw ne;
    }

    protected void wrapException(String message, PersistenceException pe) throws NamingException {
        this.wrapException(message, pe.getCause());
    }

    protected void wrapException(String message, SQLException sqle) throws NamingException {
        this.wrapException(message, (Throwable)sqle);
    }

    private String rewriteContext(String context) {
        if (context == null || "".equals(context)) {
            return CONTEXT_ROOT_OBJECT;
        }
        return context;
    }

    public void gc(Transaction transaction) throws PersistenceException {
        String agentsContextName = "adk/" + IDManagement.getHabitatID().toString() + "/" + "tryllian" + "/" + "agents";
        int deleted = this.executeUpdate(ST_GC_JNDI_NON_EXISTING_AGENTS, new String[]{agentsContextName}, transaction);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Garbage collected " + deleted + " agents in tryllian/agents"));
        }
        int deleted2 = this.executeUpdate(ST_GC_JNDI_DEAD_END_ADDRESSES, new String[]{agentsContextName}, transaction);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Garbage collected " + deleted2 + " addresses in JNDI"));
        }
    }

    public boolean isContext(String parent, String name, Transaction action) throws NamingException {
        String result = this.lookup(parent, name, action);
        return "__ARE__CONTEXT___________".equals(result);
    }

    public void bind(String context, String name, String object, String protect, Transaction action) throws NamingException {
        context = this.rewriteContext(context);
        try {
            String string = this.lookup(context, name, action);
            throw new NameAlreadyBoundException("Object " + name + " in " + context + " already bound to " + string);
        }
        catch (NameNotFoundException hopedFor) {
            try {
                int bound = this.executeUpdate(ST_BIND, new String[]{context, name, object, protect}, action);
                if (bound != 1) {
                    throw new NamingException("Could not bind " + name + " in " + context);
                }
            }
            catch (PersistenceException pe) {
                this.wrapException("Could not create subcontext " + name + " in " + context, pe);
            }
            return;
        }
    }

    public void createSubcontext(String parentContext, String name, String completeName, Transaction action) throws NamingException {
        this.bind(parentContext, name, "__ARE__CONTEXT___________", "N", action);
    }

    public void destroySubcontext(String parentContext, String name, String completeName, Transaction action) throws NamingException {
        parentContext = this.rewriteContext(parentContext);
        try {
            if (!this.isContext(parentContext, name, action)) {
                throw new InvalidNameException("Can not destroy " + name + " in " + parentContext + ": not a context");
            }
        }
        catch (NameNotFoundException nnfe) {
            return;
        }
        this.checkProtectedContext(completeName, action);
        try {
            this.executeUpdate(ST_DESTROY_SUBCONTEXT, new String[]{parentContext, name, completeName, completeName + CONTEXT_WILDCARD}, action);
        }
        catch (PersistenceException pe) {
            this.wrapException("Could not remove context " + name + " in " + parentContext, pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBindings(String parentContext, String context, Transaction action) throws NamingException {
        parentContext = this.rewriteContext(parentContext);
        ArrayList<Binding> collection = new ArrayList<Binding>();
        try {
            PooledConnection pc = this.getConnection(action);
            Connection c = pc.getConnection();
            PreparedStatement s = c.prepareStatement(ST_GET_BINDINGS);
            ResultSet result = null;
            try {
                s.setString(1, parentContext);
                result = s.executeQuery();
                while (result.next()) {
                    String id;
                    String name = result.getString(COL_NAME);
                    if (name == null || result.wasNull() || (id = result.getString(COL_ADDRESS)) == null || result.wasNull()) continue;
                    collection.add(new Binding(name, (Object)id));
                }
            }
            finally {
                s.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Could not get bindings for " + parentContext, sqle);
        }
        catch (PersistenceException pe) {
            this.wrapException("Could not get bindings for " + parentContext, pe);
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Binding b = (Binding)it.next();
            String value = (String)b.getObject();
            if (!"__ARE__CONTEXT___________".equals(value)) continue;
            b.setClassName((class$javax$naming$Context == null ? JNDIPlugin.class$("javax.naming.Context") : class$javax$naming$Context).getName());
        }
        return collection;
    }

    public String lookup(String context, String name, Transaction action) throws NamingException {
        context = this.rewriteContext(context);
        Set result = null;
        try {
            result = this.executeSelect(ST_LOOKUP, new String[]{context, name}, COL_ADDRESS, action);
        }
        catch (PersistenceException pe) {
            this.wrapException("Could not lookup " + context + "/" + name, pe);
        }
        if (result.size() == 0) {
            throw new NameNotFoundException(name + " in " + context + " is not bound");
        }
        if (result.size() > 1) {
            throw new NamingException(name + " in " + context + " is bound to multiple values");
        }
        Iterator it = result.iterator();
        return (String)it.next();
    }

    public void rebind(String context, String name, String object, String protect, Transaction action) throws NamingException {
        context = this.rewriteContext(context);
        try {
            this.lookup(context, name, action);
            this.checkProtectedBinding(context, name, action);
            this.executeUpdate(ST_REBIND, new String[]{object, protect, context, name}, action);
        }
        catch (NameNotFoundException nnfe) {
            this.bind(context, name, object, protect, action);
        }
        catch (PersistenceException pe) {
            this.wrapException("Could not rebind " + name + " in " + context, pe);
        }
    }

    public void unbind(String context, String name, Transaction action) throws NamingException {
        context = this.rewriteContext(context);
        try {
            if (this.isContext(context, name, action)) {
                throw new InvalidNameException(name + " in " + context + " cannot be unbound; it is a context");
            }
        }
        catch (NameNotFoundException nnfe) {
            return;
        }
        this.checkProtectedBinding(context, name, action);
        try {
            this.executeUpdate(ST_UNBIND, new String[]{context, name}, action);
        }
        catch (PersistenceException pe) {
            this.wrapException("Could not unbind " + name + " in " + context, pe);
        }
    }

    public void dropProtection(String context, String name, Transaction action) throws NamingException {
        try {
            this.executeUpdate(ST_DROP_PROTECTION, new String[]{"N", context, name}, action);
            this.checkProtectedBinding(context, name, action);
        }
        catch (PersistenceException pe) {
            String error = "Could not drop protection for " + name + " in " + context;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)error, (Throwable)pe);
            }
            this.wrapException(error, pe);
        }
    }

    public void unbindAll(String object, Transaction action) throws NamingException {
        try {
            this.executeUpdate(ST_UNBIND_ALL, new String[]{object}, action);
        }
        catch (PersistenceException pe) {
            this.wrapException("Could not unbind objects with value" + object, pe);
        }
    }

    public void clean(String contextPrefix, Transaction action) throws NamingException {
        try {
            this.executeUpdate(ST_CLEAN, new String[]{contextPrefix + "%", contextPrefix}, action);
        }
        catch (PersistenceException pe) {
            this.wrapException("Could not clean database", pe);
        }
    }

    private void checkProtectedBinding(String context, String name, Transaction action) throws NamingException {
        try {
            int protectCount = this.executeCount(ST_CHECK_PROTECTED_BINDING, new String[]{context, name, "Y"}, action);
            if (protectCount != 0) {
                throw new NamingConsistencyException("The binding " + name + " in " + context + " is protected, you cannot modify / remove it. ( = " + this.lookup(context, name, action));
            }
        }
        catch (PersistenceException pe) {
            throw new NamingConsistencyException("Could not check protection status", (Throwable)pe);
        }
    }

    private void checkProtectedContext(String contextFullname, Transaction action) throws NamingConsistencyException {
        try {
            int protectCount = this.executeCount(ST_CHECK_PROTECTED_CONTEXT, new String[]{contextFullname + CONTEXT_WILDCARD, "Y"}, action);
            if (protectCount != 0) {
                throw new NamingConsistencyException("There are protected bindings in " + contextFullname + "," + " you cannot modify / remove this context.");
            }
        }
        catch (PersistenceException pe) {
            throw new NamingConsistencyException("Could not check protection status", (Throwable)pe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

