/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.jdbc;

import com.tryllian.are.common.Queue;
import com.tryllian.are.jdbc.PooledConnection;
import java.io.InterruptedIOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionManager {
    private static final int TRANSACTION_LEVEL = 2;
    private static final int MAX_CONNECTIONS_DEFAULT = 10;
    private static final long CONNECTION_TIMEOUT_DEFAULT = 5000L;
    private long defaultTimeout;
    private int openConnections = 0;
    private static final int INITIAL_CONNECTIONS = 2;
    private int maxConnections;
    private static ConnectionManager instance;
    private Queue connections = new Queue();
    private String username;
    private String password;
    private String url;

    protected ConnectionManager(Properties jdbcProperties) throws SQLException {
        this.initializeProperties(jdbcProperties);
        this.initializeConnections();
    }

    public static void initialize(Properties jdbcProperties) throws SQLException {
        if (instance != null) {
            throw new IllegalStateException("Cannot initialize a singleton twice.");
        }
        instance = new ConnectionManager(jdbcProperties);
    }

    public static void shutdown() throws SQLException {
        if (instance == null) {
            throw new IllegalStateException("Cannot shutdown an uninitialized singleton");
        }
        instance.closeAllConnections();
        instance = null;
    }

    public static ConnectionManager getInstance() {
        return instance;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public PooledConnection getPooledConnection() throws SQLException, InterruptedException, InterruptedIOException {
        return this.getPooledConnection(this.defaultTimeout);
    }

    public PooledConnection getPooledConnection(long timeOut) throws SQLException, InterruptedException, InterruptedIOException {
        Queue queue = this.connections;
        synchronized (queue) {
            Connection connection;
            if (this.connections.getRetrievable() < 1 && this.openConnections < this.maxConnections) {
                connection = this.createConnection();
                this.connections.enter((Object)connection);
            }
            try {
                final Connection connectionCopy = connection = (Connection)this.connections.retrieve(timeOut);
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SQLException {
                        connectionCopy.commit();
                        return null;
                    }
                });
                return new PooledConnection(connection);
            }
            catch (SQLException sqle) {
                --this.openConnections;
                throw sqle;
            }
            catch (PrivilegedActionException pae) {
                --this.openConnections;
                throw new SQLException(pae.getMessage());
            }
        }
    }

    void restoreConnection(Connection connection) {
        this.connections.enter((Object)connection);
    }

    private void initializeConnections() throws SQLException {
        for (int i = 0; i < 2; ++i) {
            this.connections.enter((Object)this.createConnection());
        }
    }

    private void initializeProperties(Properties jdbcProperties) throws IllegalArgumentException {
        this.username = jdbcProperties.getProperty("db.jdbc2.user");
        this.password = jdbcProperties.getProperty("db.jdbc2.password");
        this.url = jdbcProperties.getProperty("db.jdbc2.url");
        if (this.username == null || this.password == null || this.url == null) {
            throw new IllegalArgumentException("Invalid connection parameters: username = " + this.username + ", password = " + this.password + ", url = " + this.url);
        }
        String poolSize = jdbcProperties.getProperty("db.jdbc2.connections.max");
        this.maxConnections = 10;
        if (poolSize != null && !"".equals(poolSize)) {
            try {
                this.maxConnections = Integer.parseInt(poolSize);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Property db.jdbc2.connections.max is not an integer: " + poolSize);
            }
        }
        String timeout = jdbcProperties.getProperty("db.jdbc2.connections.timeout");
        this.defaultTimeout = 5000L;
        if (timeout != null && !"".equals(timeout)) {
            try {
                this.defaultTimeout = Long.parseLong(timeout);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Property db.jdbc2.connections.timeout is not an integer: " + timeout);
            }
        }
    }

    private synchronized Connection createConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
        connection.setAutoCommit(false);
        if (this.supportsTransactionLevel(connection)) {
            connection.setTransactionIsolation(2);
        }
        ++this.openConnections;
        return connection;
    }

    private boolean supportsTransactionLevel(Connection c) throws SQLException {
        DatabaseMetaData metaData = c.getMetaData();
        return metaData.supportsTransactionIsolationLevel(2);
    }

    private void closeAllConnections() throws SQLException {
        while (this.connections.getRetrievable() > 0) {
            Connection connection = (Connection)this.connections.retrieve();
            if (!connection.isClosed()) {
                connection.commit();
            }
            connection.close();
            --this.openConnections;
        }
    }
}

