/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.jdbc;

import com.tryllian.are.jdbc.AbstractPlugin;
import com.tryllian.are.jdbc.PooledConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import tryllian.are.persistence.spi.ARLSerializer;
import tryllian.are.persistence.spi.AgentBuilder;
import tryllian.are.persistence.spi.AgentPersistencePlugin;
import tryllian.are.persistence.spi.AgentSerializer;
import tryllian.are.persistence.spi.PersistenceException;
import tryllian.are.persistence.spi.Transaction;

public class AgentPlugin
extends AbstractPlugin
implements AgentPersistencePlugin {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tryllian$are$jdbc$AgentPlugin == null ? (class$com$tryllian$are$jdbc$AgentPlugin = AgentPlugin.class$("com.tryllian.are.jdbc.AgentPlugin")) : class$com$tryllian$are$jdbc$AgentPlugin));
    private static final String FLAG_CHECKPOINT = "C";
    private static final String FLAG_SUSPENDED = "S";
    private static final String FLAG_IS_MOVING = "Y";
    private static final String FLAG_IS_NOT_MOVING = "N";
    private static final String COL_AGENT_ID = "agentid";
    private static final String COL_ARL_ID = "arlid";
    private static final String COL_PERISTENCY_FLAG = "persistencyflag";
    private static final String ST_UPDATE_PERSISTENCY = "UPDATE agent SET wakeuptime=?, persistencyflag=?, moving=? WHERE agentid=?";
    private static final String ST_INSERT_PERSISTENCY = "INSERT INTO agent(agentid, wakeuptime, persistencyflag, arlid) VALUES(?, ?, ?, ?)";
    private static final String ST_UPDATE_STATE = "UPDATE state SET state=?, type=? WHERE agentid=?";
    private static final String ST_INSERT_STATE = "INSERT INTO state(state, type, agentid) VALUES(?, ?, ?)";
    private static final String ST_DELETE_ATTRIBUTES = "DELETE FROM attributes WHERE agentid=?";
    private static final String ST_INSERT_ATTRIBUTE = "INSERT INTO attributes(agentid,name,value,category) VALUES(?, ?, ?, ?)";
    private static final String ST_CLEAR_ATTRIBUTES = "DELETE FROM attributes ";
    private static final String ST_CLEAR_STATE = "DELETE FROM state ";
    private static final String ST_CLEAR_AGENTS = "DELETE FROM agent ";
    private static final String ST_CONTAINS = "SELECT count(agentid) FROM agent WHERE agentid = ?";
    private static final String ST_GET_PERSISTENCY_FLAG = "SELECT persistencyflag FROM agent WHERE agentid = ?";
    private static final String ST_SET_PERSISTENCY_FLAG = "UPDATE agent SET persistencyflag = ? WHERE agentid = ?";
    private static final String ST_GET_RESTORABLE = "SELECT agentid  FROM agent WHERE  persistencyflag=? AND    wakeuptime <= ? AND wakeuptime IS NOT NULL";
    private static final String ST_GET_CHECKPOINTED = "SELECT agentid FROM agent WHERE  persistencyflag=?";
    private static final String ST_DELETE_STATE = "DELETE FROM state WHERE agentid=?";
    private static final String ST_DELETE_AGENT = "DELETE FROM agent WHERE agentid=?";
    private static final String ST_UPDATE_MOVING = "UPDATE agent SET moving=? WHERE agentid=?";
    private static final String ST_IS_MOVING = "SELECT count(agentid) FROM agent WHERE agentid=? AND moving=?";
    private static final String ST_GET_ARL = "SELECT arlid FROM agent WHERE agentid=?";
    private static final String ST_UPDATE_ARL_BY_AGENT = "UPDATE agent SET arlid=? WHERE agentid=?";
    private static final String ST_UPDATE_ARL_BY_ARLID = "UPDATE agent SET    arlid=? WHERE  arlid=? ";
    private static final String ST_SELECT_AGENT = "SELECT state, type FROM   state WHERE agentid = ? ";
    static /* synthetic */ Class class$com$tryllian$are$jdbc$AgentPlugin;

    private static Timestamp getDateAfter(long elapsedSeconds) {
        Date now = new Date();
        long nowMillis = now.getTime();
        long thenMillis = nowMillis + elapsedSeconds * 1000L;
        return new Timestamp(thenMillis);
    }

    private static void setDateField(PreparedStatement statement, int index, long elapsedSeconds) throws SQLException {
        if (elapsedSeconds == 0L) {
            statement.setNull(index, 93);
        } else {
            statement.setTimestamp(index, AgentPlugin.getDateAfter(elapsedSeconds));
        }
    }

    private void insertAttributes(String category, AgentSerializer serializer, Transaction t) throws PersistenceException {
        String agentID = serializer.getAgentID();
        Map attributes = serializer.getAgentAttributes(category);
        Iterator it = attributes.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)attributes.get(key);
            int inserted = this.executeUpdate(ST_INSERT_ATTRIBUTE, new String[]{serializer.getAgentID(), key, value, category}, t);
            if (inserted == 1) continue;
            throw new PersistenceException("Could not insert attribute " + key + " -> + " + value + " for agent " + agentID);
        }
    }

    private void insertAttributes(AgentSerializer serializer, Transaction t) throws PersistenceException {
        this.insertAttributes("runtime", serializer, t);
        this.insertAttributes("statistics", serializer, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePersistentAgent(AgentSerializer serializer, String flag, long seconds, Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        String agentID = serializer.getAgentID();
        try {
            Connection c = pc.getConnection();
            PreparedStatement s = c.prepareStatement(ST_UPDATE_PERSISTENCY);
            try {
                AgentPlugin.setDateField(s, 1, seconds);
                s.setString(2, flag);
                s.setString(3, FLAG_IS_NOT_MOVING);
                s.setString(4, agentID);
                if (s.executeUpdate() != 1) {
                    throw new PersistenceException("Could not update persisted agent " + agentID);
                }
            }
            finally {
                s.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Could not update persisted agent " + agentID, sqle);
        }
        int updated = this.executeUpdateState(ST_UPDATE_STATE, serializer.getAgentBytes(), serializer.getSerializationType(), agentID, t);
        if (updated != 1) {
            throw new PersistenceException("Could not update persisted agent state " + agentID);
        }
        int deleted = this.executeUpdate(ST_DELETE_ATTRIBUTES, new String[]{agentID}, t);
        if (deleted == 0) {
            throw new PersistenceException("Could not delete attributes for agent " + agentID);
        }
        this.insertAttributes(serializer, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAgent(AgentSerializer serializer, String flag, long seconds, Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        String agentID = serializer.getAgentID();
        try {
            Connection c = pc.getConnection();
            PreparedStatement s = c.prepareStatement(ST_INSERT_PERSISTENCY);
            try {
                s.setString(1, agentID);
                AgentPlugin.setDateField(s, 2, seconds);
                s.setString(3, flag);
                s.setString(4, serializer.getARL().getARLID());
                if (s.executeUpdate() != 1) {
                    throw new PersistenceException("Could not insert agent " + agentID);
                }
            }
            finally {
                s.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Could not store agent " + agentID, sqle);
        }
        int inserted = this.executeUpdateState(ST_INSERT_STATE, serializer.getAgentBytes(), serializer.getSerializationType(), agentID, t);
        if (inserted != 1) {
            throw new PersistenceException("Could not update persisted agent state " + agentID);
        }
        this.insertAttributes(serializer, t);
    }

    public void checkpoint(AgentSerializer serializer, Transaction action) throws PersistenceException {
        String agentID = serializer.getAgentID();
        boolean agentExists = this.contains(agentID, action);
        if (agentExists) {
            this.updatePersistentAgent(serializer, FLAG_CHECKPOINT, 0L, action);
        } else {
            this.storeAgent(serializer, FLAG_CHECKPOINT, 0L, action);
        }
    }

    public void suspend(AgentSerializer serializer, long seconds, Transaction action) throws PersistenceException {
        String agentID = serializer.getAgentID();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Suspending agent " + serializer));
        }
        if (this.contains(agentID, action)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Agent already exists");
            }
            this.updatePersistentAgent(serializer, FLAG_SUSPENDED, seconds, action);
        } else {
            this.storeAgent(serializer, FLAG_SUSPENDED, seconds, action);
        }
    }

    public void upgrade(AgentSerializer serializer, ARLSerializer newARL, Transaction action) throws PersistenceException {
        this.executeUpdate(ST_UPDATE_ARL_BY_AGENT, new String[]{newARL.getARLID(), serializer.getAgentID()}, action);
    }

    public void upgrade(String arlID, ARLSerializer newARL, Transaction action) throws PersistenceException {
        this.executeUpdate(ST_UPDATE_ARL_BY_ARLID, new String[]{newARL.getARLID(), arlID}, action);
    }

    public boolean contains(String agentID, Transaction action) throws PersistenceException {
        int count = this.executeCount(ST_CONTAINS, new String[]{agentID}, action);
        return count > 0;
    }

    public String getPersistencyFlag(String agentID, Transaction action) throws PersistenceException {
        Set result = this.executeSelect(ST_GET_PERSISTENCY_FLAG, new String[]{agentID}, COL_PERISTENCY_FLAG, action);
        if (result.size() != 1) {
            return null;
        }
        Iterator it = result.iterator();
        return (String)it.next();
    }

    public void setPersistencyFlag(String agentID, String flag, Transaction action) throws PersistenceException {
        if (!FLAG_CHECKPOINT.equals(flag) && !FLAG_SUSPENDED.equals(flag)) {
            throw new IllegalArgumentException(flag + " illegal");
        }
        this.executeUpdate(ST_SET_PERSISTENCY_FLAG, new String[]{flag, agentID}, action);
    }

    public void remove(String agentID, Transaction action) throws PersistenceException {
        this.executeUpdate(ST_DELETE_ATTRIBUTES, new String[]{agentID}, action);
        this.executeUpdate(ST_DELETE_STATE, new String[]{agentID}, action);
        this.executeUpdate(ST_DELETE_AGENT, new String[]{agentID}, action);
    }

    public void removeMoving(String agentID, Transaction action) throws PersistenceException {
        if (this.isDeparting(agentID, action)) {
            this.remove(agentID, action);
        }
    }

    public void setDeparting(String agentID, boolean enabled, Transaction action) throws PersistenceException {
        String flag = enabled ? FLAG_IS_MOVING : FLAG_IS_NOT_MOVING;
        this.executeUpdate(ST_UPDATE_MOVING, new String[]{flag, agentID}, action);
    }

    public boolean isDeparting(String agentID, Transaction action) throws PersistenceException {
        int count = this.executeCount(ST_IS_MOVING, new String[]{agentID, FLAG_IS_MOVING}, action);
        return count == 1;
    }

    public void restore(String agentID, AgentBuilder builder, Transaction action) throws PersistenceException {
        if (!this.contains(agentID, action)) {
            throw new PersistenceException("No such agent in this database");
        }
        builder.setAgentID(agentID);
        Map map = this.retrieveAttributes(agentID, "runtime", action);
        builder.setAgentAttributes(map, "runtime");
        map = this.retrieveAttributes(agentID, "statistics", action);
        builder.setAgentAttributes(map, "statistics");
        this.retrieveState(agentID, builder, action);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Retrieved agent");
        }
        this.executeUpdate("UPDATE agent SET persistencyflag=?  WHERE agentid=?", new String[]{FLAG_CHECKPOINT, agentID}, action);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("State set to checkpointed for " + agentID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void retrieveState(String agentID, AgentBuilder builder, Transaction action) throws PersistenceException {
        block27: {
            PooledConnection pc = this.getConnection(action);
            InputStream is = null;
            PreparedStatement stmt = null;
            Connection c = pc.getConnection();
            stmt = c.prepareStatement(ST_SELECT_AGENT);
            stmt.setString(1, agentID);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                int len;
                is = result.getBinaryStream(1);
                if (is == null) {
                    throw new PersistenceException("Serialized state was null " + agentID);
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((len = is.read(buf)) > 0) {
                    bos.write(buf, 0, len);
                }
                bos.close();
                byte[] state = bos.toByteArray();
                String type = result.getString("type");
                if (type == null || result.wasNull()) {
                    throw new PersistenceException("Serialization type was  empty for: " + agentID);
                }
                if (result.next()) {
                    throw new PersistenceException("Too many states found for: " + agentID);
                }
                builder.setAgent(state);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting state for " + agentID + " to " + type));
                }
                builder.setSerializationType(type);
            }
            Object var15_16 = null;
            try {
                stmt.close();
            }
            catch (SQLException sqle2) {
                // empty catch block
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe2) {}
            }
            break block27;
            {
                catch (SQLException sqle) {
                    this.wrapException("Could not retrieve state for agent " + agentID, sqle);
                    Object var15_17 = null;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioe2) {}
                    }
                    break block27;
                }
                catch (IOException ioe) {
                    this.wrapException("Could not retrieve state for agent " + agentID, ioe);
                    Object var15_18 = null;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioe2) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                try {
                    stmt.close();
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map retrieveAttributes(String agentID, String category, Transaction action) throws PersistenceException {
        PooledConnection pc = this.getConnection(action);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Statement stmt = null;
        try {
            String s = " select name  ,      value  from   attributes  where  agentid = ?  and    category = ? ";
            Connection c = pc.getConnection();
            stmt = c.prepareStatement(s);
            stmt.setString(1, agentID);
            stmt.setString(2, category);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String name = result.getString("name");
                if (name == null || result.wasNull()) {
                    throw new PersistenceException("name was empty for: " + agentID);
                }
                String value = result.getString("value");
                if (value == null || result.wasNull()) {
                    throw new PersistenceException("value was empty for: " + agentID);
                }
                resultMap.put(name, value);
            }
        }
        catch (SQLException sqle) {
            this.wrapException("SQL exception retrieving agent attributes for category " + category + ", agent " + agentID, sqle);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException sqle) {}
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getRestorable(Transaction action) throws PersistenceException {
        PooledConnection pc = this.getConnection(action);
        HashSet<String> set = new HashSet<String>();
        try {
            Connection c = pc.getConnection();
            PreparedStatement s = c.prepareStatement(ST_GET_RESTORABLE);
            ResultSet result = null;
            try {
                s.setString(1, FLAG_SUSPENDED);
                s.setTimestamp(2, AgentPlugin.getDateAfter(0L));
                result = s.executeQuery();
                while (result.next()) {
                    String name = result.getString(COL_AGENT_ID);
                    if (name == null || result.wasNull()) continue;
                    set.add(name);
                }
            }
            finally {
                s.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Could not select restorables", sqle);
        }
        return set;
    }

    public Set getCheckpointed(Transaction action) throws PersistenceException {
        return this.executeSelect(ST_GET_CHECKPOINTED, new String[]{FLAG_CHECKPOINT}, COL_AGENT_ID, action);
    }

    public void clear(Transaction action) throws PersistenceException {
        this.executeUpdate(ST_CLEAR_ATTRIBUTES, new String[0], action);
        this.executeUpdate(ST_CLEAR_STATE, new String[0], action);
        this.executeUpdate(ST_CLEAR_AGENTS, new String[0], action);
    }

    public String getARLID(String agentID, Transaction action) throws PersistenceException {
        Set result = this.executeSelect(ST_GET_ARL, new String[]{agentID}, COL_ARL_ID, action);
        if (result.size() != 1) {
            throw new PersistenceException("Could not find one ARLID for " + agentID + ": " + result);
        }
        Iterator it = result.iterator();
        return (String)it.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdateState(String statement, byte[] state, String type, String agentID, Transaction transaction) throws PersistenceException {
        int n;
        PooledConnection pc = this.getConnection(transaction);
        Connection c = pc.getConnection();
        PreparedStatement stmt = c.prepareStatement(statement);
        try {
            if (state == null) {
                stmt.setNull(1, -4);
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(state);
                stmt.setBinaryStream(1, (InputStream)bais, state.length);
            }
            stmt.setString(2, type);
            stmt.setString(3, agentID);
            n = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException sqle) {
                this.wrapException("Could not update table: " + statement, sqle);
                return 0;
            }
        }
        stmt.close();
        return n;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

