/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.jdbc;

import com.tryllian.are.jdbc.PooledConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import tryllian.are.persistence.spi.PersistenceException;
import tryllian.are.persistence.spi.Transaction;

public abstract class AbstractPlugin {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tryllian$are$jdbc$AbstractPlugin == null ? (class$com$tryllian$are$jdbc$AbstractPlugin = AbstractPlugin.class$("com.tryllian.are.jdbc.AbstractPlugin")) : class$com$tryllian$are$jdbc$AbstractPlugin));
    protected static final boolean DEBUG = false;
    static /* synthetic */ Class class$com$tryllian$are$jdbc$AbstractPlugin;

    protected void logStatement(String statement, Object[] args) {
        StringBuffer argString = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                argString.append("<null> ");
                continue;
            }
            argString.append(args[i].toString());
            argString.append(" ");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing SQL statement " + statement + " " + argString));
        }
    }

    protected void wrapException(String message, Exception e) throws PersistenceException {
        throw new PersistenceException(message, (Throwable)e);
    }

    protected PooledConnection getConnection(Transaction transaction) throws PersistenceException {
        try {
            return (PooledConnection)transaction;
        }
        catch (ClassCastException cce) {
            this.wrapException("Wrong type of transaction: " + transaction.getClass(), cce);
            return null;
        }
    }

    private static void setArguments(PreparedStatement s, String[] args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            String current = args[i];
            if (current == null) {
                s.setNull(i + 1, 12);
                continue;
            }
            s.setString(i + 1, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeCount(String statement, String[] args, Transaction transaction) throws PersistenceException {
        PooledConnection pc = this.getConnection(transaction);
        this.logStatement(statement, args);
        try {
            Connection c = pc.getConnection();
            PreparedStatement s = c.prepareStatement(statement);
            ResultSet result = null;
            try {
                AbstractPlugin.setArguments(s, args);
                result = s.executeQuery();
                if (!result.next()) return 0;
                int count = result.getInt(1);
                if (result.wasNull()) {
                    throw new PersistenceException("Counting resulted in a NULL object: " + statement);
                }
                int n = count;
                return n;
            }
            finally {
                s.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Could not count: " + statement, sqle);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set executeSelect(String statement, String[] args, String resultCol, Transaction transaction) throws PersistenceException {
        PooledConnection pc = this.getConnection(transaction);
        HashSet<String> collection = new HashSet<String>();
        this.logStatement(statement, args);
        try {
            Connection c = pc.getConnection();
            PreparedStatement s = c.prepareStatement(statement);
            ResultSet result = null;
            try {
                AbstractPlugin.setArguments(s, args);
                result = s.executeQuery();
                while (result.next()) {
                    String name = result.getString(resultCol);
                    if (name == null || result.wasNull()) continue;
                    collection.add(name);
                }
            }
            finally {
                s.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Could not select: " + statement, sqle);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdate(String statement, String[] args, Transaction transaction) throws PersistenceException {
        int n;
        PooledConnection pc = this.getConnection(transaction);
        this.logStatement(statement, args);
        Connection c = pc.getConnection();
        PreparedStatement s = c.prepareStatement(statement);
        try {
            AbstractPlugin.setArguments(s, args);
            n = s.executeUpdate();
        }
        catch (Throwable throwable) {
            try {
                s.close();
                throw throwable;
            }
            catch (SQLException sqle) {
                this.wrapException("Could not update table: " + statement, sqle);
                return 0;
            }
        }
        s.close();
        return n;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

