/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.jdbc;

import com.tryllian.are.codecontrol.JarCache;
import com.tryllian.are.jdbc.AbstractPlugin;
import com.tryllian.are.jdbc.PooledConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import tryllian.are.persistence.spi.ARLBuilder;
import tryllian.are.persistence.spi.ARLPersistencePlugin;
import tryllian.are.persistence.spi.ARLSerializer;
import tryllian.are.persistence.spi.PersistenceException;
import tryllian.are.persistence.spi.Transaction;

public class ARLPlugin
extends AbstractPlugin
implements ARLPersistencePlugin {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$tryllian$are$jdbc$ARLPlugin == null ? (class$com$tryllian$are$jdbc$ARLPlugin = ARLPlugin.class$("com.tryllian.are.jdbc.ARLPlugin")) : class$com$tryllian$are$jdbc$ARLPlugin));
    static /* synthetic */ Class class$com$tryllian$are$jdbc$ARLPlugin;

    public void clear(Transaction t) throws PersistenceException {
        String s = "delete from arljars";
        this.executeUpdate(s, "Could not delete from arljars", t);
        s = "delete from jarurl";
        this.executeUpdate(s, "Could not delete from jarurl", t);
        s = "delete from arl";
        this.executeUpdate(s, "Could not delete from arl", t);
    }

    public void gc(Transaction t) throws PersistenceException {
        this.deleteUnusedJarUrlMappings(t);
        this.deleteUnusedARLS(t);
        this.deleteUnusedJarfiles(t);
        this.deleteUnusedJars(t);
    }

    private void deleteUnusedJarUrlMappings(Transaction t) throws PersistenceException {
        String s = " delete from arljars where  arlid not in ( select distinct arlid                       from   agent)";
        this.executeUpdate(s, new String[0], t);
    }

    private void deleteUnusedARLS(Transaction t) throws PersistenceException {
        String s = " delete from arl where  arlid not in (select distinct agent.arlid                       from   agent)";
        this.executeUpdate(s, new String[0], t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUnusedJarfiles(Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        URL url = null;
        try {
            String s = " select url  from   jarurl  where  jarid not in (select distinct jarid                       from   arljars)";
            Connection c = pc.getConnection();
            PreparedStatement stmt = c.prepareStatement(s);
            ResultSet result = stmt.executeQuery();
            try {
                while (result.next()) {
                    try {
                        url = new URL(result.getString(1));
                        if (JarCache.garbageCollectCacheFile((URL)url)) continue;
                        throw new PersistenceException("Could not delete file " + url.getFile());
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("could not delete file " + url.getFile()));
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Error retrieving unused jar urls.", sqle);
        }
    }

    private void deleteUnusedJars(Transaction t) throws PersistenceException {
        String s = " delete from jarurl where  jarid not in (select distinct jarid                       from   arljars )";
        this.executeUpdate(s, new String[0], t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ARLSerializer arlSerializer, Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        if (this.contains(arlSerializer.getARLID(), t)) {
            return;
        }
        try {
            String s = " insert into arl  (arlid, mainclass, typedescription)  values  (?, ?, ?)";
            Connection c = pc.getConnection();
            PreparedStatement stmt = c.prepareStatement(s);
            try {
                stmt.setString(1, arlSerializer.getARLID());
                stmt.setString(2, arlSerializer.getMainClass());
                stmt.setString(3, "XXX");
                if (stmt.executeUpdate() != 1) {
                    throw new PersistenceException("Could not store " + arlSerializer.getARLID());
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Could not store ARL" + arlSerializer.getARLID(), sqle);
        }
        this.mapJars(arlSerializer, "S", t);
        this.mapJars(arlSerializer, "A", t);
    }

    private void mapJars(ARLSerializer arlSerializer, String type, Transaction t) throws PersistenceException {
        Map jarURLs = arlSerializer.getJarURLs(type);
        Iterator it = jarURLs.keySet().iterator();
        while (it.hasNext()) {
            String currentID = (String)it.next();
            String currentURL = (String)jarURLs.get(currentID);
            if (this.jarExists(currentID, t)) {
                this.insertARLJar(arlSerializer.getARLID(), currentID, type, t);
                continue;
            }
            this.insertJarURL(currentID, currentURL, t);
            this.insertARLJar(arlSerializer.getARLID(), currentID, type, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jarExists(String jarid, Transaction t) throws PersistenceException {
        int count;
        block6: {
            PooledConnection pc = this.getConnection(t);
            count = -1;
            try {
                String s = " select count(*)  from   jarurl where  jarid = ? ";
                Connection c = pc.getConnection();
                PreparedStatement stmt = c.prepareStatement(s);
                try {
                    stmt.setString(1, jarid);
                    ResultSet result = stmt.executeQuery();
                    if (result.next()) {
                        count = result.getInt(1);
                        break block6;
                    }
                    throw new PersistenceException("Database corruped while trying to determine the number of jars in the jarcache with  jarid " + jarid);
                }
                finally {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                this.wrapException("Could not read jarurls for " + jarid, sqle);
            }
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertJarURL(String jarid, String url, Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        try {
            String s = " insert into jarurl  (jarid, url)  values  (?, ?)";
            Connection c = pc.getConnection();
            PreparedStatement stmt = c.prepareStatement(s);
            try {
                stmt.setString(1, jarid);
                stmt.setString(2, url);
                if (stmt.executeUpdate() != 1) {
                    throw new PersistenceException("Could not store jarurl " + jarid + ", " + url);
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Could not store JarURL: " + jarid + ", " + url, sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertARLJar(String arlid, String jarid, String type, Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        try {
            String s = " insert into arljars  (arlid, jarid, type)  values  (?, ?, ?)";
            Connection c = pc.getConnection();
            PreparedStatement stmt = c.prepareStatement(s);
            try {
                stmt.setString(1, arlid);
                stmt.setString(2, jarid);
                stmt.setString(3, type);
                if (stmt.executeUpdate() != 1) {
                    throw new PersistenceException("Could not store arljar: " + arlid + ", " + jarid);
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Error storing arljar: " + arlid + " , " + jarid, sqle);
        }
    }

    public void get(String agentID, ARLBuilder builder, Transaction t) throws PersistenceException {
        String arlid = this.getAgentARLID(agentID, t);
        builder.setARLID(arlid);
        String mainClass = this.getMainClass(arlid, t);
        builder.setMainClass(mainClass);
        this.addJars(builder, "A", arlid, t);
        this.addJars(builder, "S", arlid, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJars(ARLBuilder builder, String type, String arlid, Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String s = "select arljars.jarid ,      jarurl.url from   arljars ,      jarurl where  jarurl.jarid = arljars.jarid and    arljars.arlid = ? and    arljars.type  = ? ";
            Connection c = pc.getConnection();
            PreparedStatement stmt = c.prepareStatement(s);
            try {
                stmt.setString(1, arlid);
                stmt.setString(2, type);
                ResultSet result = stmt.executeQuery();
                while (result.next()) {
                    map.put(result.getString(1), result.getString(2));
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Error retrieving jar-arl mappings for " + arlid, sqle);
        }
        try {
            builder.setJarURLs(map, type);
        }
        catch (Exception e) {
            this.wrapException("Error adding url to arlbuilder for " + arlid, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMainClass(String arlid, Transaction t) throws PersistenceException {
        String mainClass;
        block7: {
            mainClass = null;
            PooledConnection pc = this.getConnection(t);
            try {
                String s = "select mainclass from arl where arlid = ?";
                Connection c = pc.getConnection();
                PreparedStatement stmt = c.prepareStatement(s);
                try {
                    stmt.setString(1, arlid);
                    ResultSet result = stmt.executeQuery();
                    if (result.next()) {
                        mainClass = result.getString(1);
                        break block7;
                    }
                    throw new PersistenceException("Database corruped while trying to retrieve the mainclass  for arl " + arlid);
                }
                finally {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                this.wrapException("Could not retrieve the mainclass for " + arlid, sqle);
            }
        }
        if (mainClass == null) {
            throw new PersistenceException("Retrieved null arlid for arl " + arlid);
        }
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAgentARLID(String agentid, Transaction t) throws PersistenceException {
        String arlid;
        block7: {
            arlid = null;
            PooledConnection pc = this.getConnection(t);
            try {
                String s = "select arlid from agent where agentid = ?";
                Connection c = pc.getConnection();
                PreparedStatement stmt = c.prepareStatement(s);
                try {
                    stmt.setString(1, agentid);
                    ResultSet result = stmt.executeQuery();
                    if (result.next()) {
                        arlid = result.getString(1);
                        break block7;
                    }
                    throw new PersistenceException("Database corruped while trying to retrieve the arlid for agent" + agentid);
                }
                finally {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                this.wrapException("Could not read arlid for " + agentid, sqle);
            }
        }
        if (arlid == null) {
            throw new PersistenceException("Retrieved null arlid for agent " + agentid);
        }
        return arlid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String arlid, Transaction t) throws PersistenceException {
        boolean bl;
        PooledConnection pc = this.getConnection(t);
        String s = "select arlid from arl where arlid = ?";
        Connection c = pc.getConnection();
        PreparedStatement stmt = c.prepareStatement(s);
        try {
            stmt.setString(1, arlid);
            ResultSet result = stmt.executeQuery();
            bl = result.next();
        }
        catch (Throwable throwable) {
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException sqle) {
                this.wrapException("Could not read arlid " + arlid, sqle);
                return false;
            }
        }
        stmt.close();
        return bl;
    }

    public void remove(String arlid, Transaction t) throws PersistenceException {
        if (this.arlInUse(arlid, t)) {
            throw new PersistenceException("ARL " + arlid + " still in use!");
        }
        this.deleteARLJarMapping(arlid, t);
        this.deleteARL(arlid, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean arlInUse(String arlid, Transaction t) throws PersistenceException {
        int count;
        block6: {
            PooledConnection pc = this.getConnection(t);
            count = -1;
            try {
                String s = " select count(*)  from   agent where  arlid = ? ";
                Connection c = pc.getConnection();
                PreparedStatement stmt = c.prepareStatement(s);
                try {
                    stmt.setString(1, arlid);
                    ResultSet result = stmt.executeQuery();
                    if (result.next()) {
                        count = result.getInt(1);
                        break block6;
                    }
                    throw new PersistenceException("Database corruped while trying to determine the number of arls in use with id " + arlid);
                }
                finally {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                this.wrapException("Could not read jarurls for " + arlid, sqle);
            }
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteARLJarMapping(String arlid, Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        try {
            String s = " delete from arljars  where arlid = ? ";
            Connection c = pc.getConnection();
            PreparedStatement stmt = c.prepareStatement(s);
            try {
                stmt.setString(1, arlid);
                stmt.executeUpdate();
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Could not remove jarurl mappings for " + arlid, sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteARL(String arlid, Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        try {
            String s = " delete from arl  where arlid = ? ";
            Connection c = pc.getConnection();
            PreparedStatement stmt = c.prepareStatement(s);
            try {
                stmt.setString(1, arlid);
                stmt.executeUpdate();
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Could not remove arl " + arlid, sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getURLs(Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        HashSet<URL> set = new HashSet<URL>();
        URL url = null;
        try {
            String s = " select distinct jarurl.url  from   jarurl  ,      arljars  where  jarurl.jarid = arljars.jarid  and    arljars.arlid in (select distinct arlid                           from   agent) ";
            Connection c = pc.getConnection();
            PreparedStatement stmt = c.prepareStatement(s);
            ResultSet result = stmt.executeQuery();
            try {
                while (result.next()) {
                    try {
                        url = new URL(result.getString(1));
                        set.add(url);
                    }
                    catch (Exception e) {
                        this.wrapException("Could not create url", e);
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Error retrieving unused jar urls.", sqle);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL(String jarid, Transaction t) throws PersistenceException {
        String url;
        block7: {
            url = null;
            PooledConnection pc = this.getConnection(t);
            try {
                String s = " select url  from   jarurl  where  jarid = ? ";
                Connection c = pc.getConnection();
                PreparedStatement stmt = c.prepareStatement(s);
                try {
                    stmt.setString(1, jarid);
                    ResultSet result = stmt.executeQuery();
                    if (result.next()) {
                        url = result.getString(1);
                        break block7;
                    }
                    throw new PersistenceException("Database corruped while trying to retrieve the url for  jar " + jarid);
                }
                finally {
                    stmt.close();
                }
            }
            catch (SQLException sqle) {
                this.wrapException("Could not read url for jar " + jarid, sqle);
            }
        }
        if (url == null) {
            throw new PersistenceException("Retrieved null url for jar " + jarid);
        }
        return url;
    }

    public void putURL(String arlID, String jarID, String url, String type, Transaction t) throws PersistenceException {
        if (!this.jarExists(jarID, t)) {
            this.insertJarURL(jarID, url, t);
        }
        this.insertARLJar(arlID, jarID, type, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getJars(Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        HashMap<String, URL> map = new HashMap<String, URL>();
        String jarid = null;
        URL url = null;
        try {
            String s = " select jarid  ,      url  from   jarurl ";
            Connection c = pc.getConnection();
            PreparedStatement stmt = c.prepareStatement(s);
            ResultSet result = stmt.executeQuery();
            try {
                while (result.next()) {
                    try {
                        jarid = result.getString(1);
                        url = new URL(result.getString(2));
                        map.put(jarid, url);
                    }
                    catch (Exception e) {
                        this.wrapException("Could not create url", e);
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException("Error retrieving used jar urls.", sqle);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(String s, String errorMessage, Transaction t) throws PersistenceException {
        PooledConnection pc = this.getConnection(t);
        try {
            Connection c = pc.getConnection();
            PreparedStatement stmt = c.prepareStatement(s);
            try {
                stmt.executeUpdate();
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            this.wrapException(errorMessage, sqle);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

