/*
 * Decompiled with CFR 0.152.
 */
package jargs.gnu;

import java.util.Hashtable;
import java.util.Vector;

public class CmdLineParser {
    private String[] remainingArgs = null;
    private Hashtable options = new Hashtable(10);
    private Hashtable values = new Hashtable(10);

    public final void addOption(Option option) {
        this.options.put("-" + option.shortForm(), option);
        this.options.put("--" + option.longForm(), option);
    }

    public final Option addStringOption(char c, String string) {
        Option.StringOption stringOption = new Option.StringOption(c, string);
        this.addOption(stringOption);
        return stringOption;
    }

    public final Option addIntegerOption(char c, String string) {
        Option.IntegerOption integerOption = new Option.IntegerOption(c, string);
        this.addOption(integerOption);
        return integerOption;
    }

    public final Option addBooleanOption(char c, String string) {
        Option.BooleanOption booleanOption = new Option.BooleanOption(c, string);
        this.addOption(booleanOption);
        return booleanOption;
    }

    public final Object getOptionValue(Option option) {
        return this.values.get(option.longForm());
    }

    public final String[] getRemainingArgs() {
        return this.remainingArgs;
    }

    public void parse(String[] stringArray) throws IllegalOptionValueException, UnknownOptionException {
        Object object;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            Option option;
            int n2;
            String string = stringArray[n];
            if (!string.startsWith("-")) break;
            if (string.equals("--")) {
                ++n;
                break;
            }
            object = null;
            if (string.startsWith("--") && (n2 = string.indexOf("=")) != -1) {
                object = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
            if ((option = (Option)this.options.get(string)) == null) {
                throw new UnknownOptionException(string);
            }
            Object object2 = null;
            if (option.wantsValue()) {
                if (object == null) {
                    object = null;
                    if (++n < stringArray.length) {
                        object = stringArray[n];
                    }
                }
                object2 = option.getValue((String)object);
            } else {
                object2 = option.getValue(null);
            }
            this.values.put(option.longForm(), object2);
            ++n;
        }
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        this.remainingArgs = new String[vector.size()];
        int n3 = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.remainingArgs[n3] = (String)object.nextElement();
            ++n3;
        }
    }

    public static abstract class Option {
        private String shortForm = null;
        private String longForm = null;
        private boolean wantsValue = false;

        protected Option(char c, String string, boolean bl) {
            if (string == null) {
                throw new IllegalArgumentException("null arg forms not allowed");
            }
            this.shortForm = new String(new char[]{c});
            this.longForm = string;
            this.wantsValue = bl;
        }

        public String shortForm() {
            return this.shortForm;
        }

        public String longForm() {
            return this.longForm;
        }

        public boolean wantsValue() {
            return this.wantsValue;
        }

        public final Object getValue(String string) throws IllegalOptionValueException {
            if (this.wantsValue) {
                if (string == null) {
                    throw new IllegalOptionValueException(this, "");
                }
                return this.parseValue(string);
            }
            return Boolean.TRUE;
        }

        protected Object parseValue(String string) throws IllegalOptionValueException {
            return null;
        }

        public static class StringOption
        extends Option {
            public StringOption(char c, String string) {
                super(c, string, true);
            }

            protected Object parseValue(String string) {
                return string;
            }
        }

        public static class IntegerOption
        extends Option {
            public IntegerOption(char c, String string) {
                super(c, string, true);
            }

            protected Object parseValue(String string) throws IllegalOptionValueException {
                try {
                    return new Integer(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalOptionValueException(this, string);
                }
            }
        }

        public static class BooleanOption
        extends Option {
            public BooleanOption(char c, String string) {
                super(c, string, false);
            }
        }
    }

    public static class IllegalOptionValueException
    extends OptionException {
        private Option option;
        private String value;

        IllegalOptionValueException(Option option, String string) {
            super("illegal value '" + string + "' for option -" + option.shortForm() + "/--" + option.longForm());
            this.option = option;
            this.value = string;
        }

        public Option getOption() {
            return this.option;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class UnknownOptionException
    extends OptionException {
        private String optionName = null;

        UnknownOptionException(String string) {
            super("unknown option '" + string + "'");
            this.optionName = string;
        }

        public String getOptionName() {
            return this.optionName;
        }
    }

    public static abstract class OptionException
    extends Exception {
        OptionException(String string) {
            super(string);
        }
    }
}

