/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.startup;

import com.tryllian.are.startup.JarDirClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.StringTokenizer;

public class StartHabitat {
    private String[] args = new String[0];
    private String className = "com.tryllian.mptools.XMLHabitat";
    private boolean debug = false;
    private ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader();
    private File[] extraClassLoaderAdditions = new File[0];

    public void setArguments(String[] args) {
        this.args = args;
    }

    public String[] getArguments() {
        return this.args;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setParentClassLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public void setExtraClassLoaderAdditions(File[] files) {
        this.extraClassLoaderAdditions = (File[])files.clone();
    }

    public File[] getExtraClassLoaderAdditions() {
        return (File[])this.extraClassLoaderAdditions.clone();
    }

    public void start() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException, SecurityException {
        String configDir;
        String areHome;
        if (this.debug) {
            System.err.println("Starting habitat...");
        }
        if ((areHome = System.getProperty("are.home")) == null || areHome.equals("")) {
            File areHomeDir;
            for (areHomeDir = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile(); !(areHomeDir == null || new File(areHomeDir, "config").exists() && new File(areHomeDir, "lib").exists()); areHomeDir = areHomeDir.getParentFile()) {
            }
            if (areHomeDir == null) {
                throw new IOException("Couldn't find are.home");
            }
            areHome = areHomeDir.toString();
        }
        areHome = new File(areHome).getCanonicalPath();
        System.setProperty("are.home", areHome);
        if (this.debug) {
            System.err.println("are.home: " + areHome);
        }
        if ((configDir = System.getProperty("are.configdir")) == null) {
            configDir = areHome + File.separator + "config";
            System.setProperty("are.configdir", configDir);
        }
        if (this.debug) {
            System.err.println("are.configdir: " + configDir);
        }
        File libDir = new File(areHome + File.separator + "lib");
        if (this.debug) {
            System.err.println("libraries loaded from: " + libDir);
        }
        File[] files = new File[3 + this.extraClassLoaderAdditions.length];
        files[0] = new File(libDir, "are.jar");
        files[1] = new File(libDir, "runtime");
        files[2] = new File(libDir, "jdbc");
        for (int i = 0; i < this.extraClassLoaderAdditions.length; ++i) {
            if (this.debug) {
                System.err.println("Adding class loader addition: " + this.extraClassLoaderAdditions[i]);
            }
            files[i + 3] = this.extraClassLoaderAdditions[i];
        }
        JarDirClassLoader cl = new JarDirClassLoader(files);
        if (this.debug) {
            System.err.println("ClassLoader URLs: " + Arrays.asList(cl.getURLs()));
        }
        Thread.currentThread().setContextClassLoader(cl);
        String policy = System.getProperty("java.security.policy");
        if (policy == null) {
            policy = configDir + File.separator + "are-security.policy";
            System.setProperty("java.security.policy", policy);
        }
        if (this.debug) {
            System.err.println("Security Manager: " + System.getSecurityManager());
        }
        if (this.debug) {
            System.err.println("java.security.policy: " + policy);
        }
        if (this.debug) {
            System.err.println("startup classname: " + this.className);
        }
        Class<?> c = cl.loadClass(this.className);
        Class[] paramTypes = new Class[]{this.args.getClass()};
        Method m = c.getDeclaredMethod("main", paramTypes);
        Object[] methodArgs = new Object[]{this.args};
        m.invoke(null, methodArgs);
        if (this.debug) {
            System.err.println(this.className + " started...");
        }
    }

    public static void main(String[] args) throws Exception {
        String extraFiles;
        String className;
        StartHabitat sh = new StartHabitat();
        if (Boolean.getBoolean("tryllian.are.startup.debug")) {
            sh.setDebug(true);
        }
        if ((className = System.getProperty("tryllian.are.startup.classname")) != null) {
            sh.setClassName(className);
        }
        if ((extraFiles = System.getProperty("tryllian.are.startup.extraclassloaderfiles")) != null) {
            StringTokenizer st = new StringTokenizer(extraFiles, "," + File.pathSeparator);
            File[] additions = new File[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                additions[i] = new File(st.nextToken());
                ++i;
            }
            sh.setExtraClassLoaderAdditions(additions);
        }
        sh.setArguments(args);
        sh.start();
    }
}

