/*
 * Decompiled with CFR 0.152.
 */
package com.tryllian.are.startup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

class JarDirClassLoader
extends URLClassLoader {
    public JarDirClassLoader(File[] files) throws IOException {
        this(files, ClassLoader.getSystemClassLoader());
    }

    public JarDirClassLoader(File[] files, ClassLoader parent) throws IOException {
        super(JarDirClassLoader.getJarURLs(files), parent);
    }

    private static URL[] getJarURLs(File[] files) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                urls.addAll(JarDirClassLoader.getJars(files[i], true));
                continue;
            }
            urls.add(files[i].toURL());
        }
        URL[] array = new URL[urls.size()];
        urls.toArray(array);
        return array;
    }

    private static List getJars(File dir, boolean recurse) throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        File[] jars = dir.listFiles(new JarZipFilter());
        if (jars == null) {
            throw new IOException("listFiles (JarZipFilter) returned null for " + dir);
        }
        for (int i = 0; i < jars.length; ++i) {
            list.add(jars[i].toURL());
        }
        if (recurse) {
            File[] dirs = dir.listFiles(new DirFilter());
            if (dirs == null) {
                throw new IOException("listFiles (DirFilter) returned null for " + dir);
            }
            for (int i = 0; i < dirs.length; ++i) {
                list.addAll(JarDirClassLoader.getJars(dirs[i], true));
            }
        }
        return list;
    }

    private static class JarZipFilter
    implements FileFilter {
        private JarZipFilter() {
        }

        public boolean accept(File f) {
            String name = f.getName().toLowerCase();
            return name.endsWith(".zip") || name.endsWith(".jar");
        }
    }

    private static class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory();
        }
    }
}

