/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import org.opennms.protocols.snmp.SnmpNull;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpVarBind
implements SnmpSyntax,
Cloneable,
Serializable {
    static final long serialVersionUID = 2328987288282447623L;
    private SnmpObjectId m_name;
    private SnmpSyntax m_value;
    public static final byte ASNTYPE = 48;

    public SnmpVarBind() {
        this.m_name = new SnmpObjectId();
        this.m_value = new SnmpNull();
    }

    public SnmpVarBind(SnmpObjectId snmpObjectId) {
        this.m_name = (SnmpObjectId)snmpObjectId.duplicate();
        this.m_value = new SnmpNull();
    }

    public SnmpVarBind(SnmpObjectId snmpObjectId, SnmpSyntax snmpSyntax) {
        this.m_name = (SnmpObjectId)snmpObjectId.duplicate();
        this.m_value = snmpSyntax.duplicate();
    }

    public SnmpVarBind(String string) {
        this.m_name = new SnmpObjectId(string);
        this.m_value = new SnmpNull();
    }

    public SnmpVarBind(String string, SnmpSyntax snmpSyntax) {
        this.m_name = new SnmpObjectId(string);
        this.m_value = snmpSyntax.duplicate();
    }

    public SnmpVarBind(SnmpVarBind snmpVarBind) {
        this.m_name = (SnmpObjectId)snmpVarBind.m_name.duplicate();
        this.m_value = snmpVarBind.m_value.duplicate();
    }

    public SnmpObjectId getName() {
        return this.m_name;
    }

    public void setName(SnmpObjectId snmpObjectId) {
        this.m_name = (SnmpObjectId)snmpObjectId.duplicate();
    }

    public void setName(String string) {
        this.m_name = new SnmpObjectId(string);
    }

    public SnmpSyntax getValue() {
        return this.m_value;
    }

    public void setValue(SnmpSyntax snmpSyntax) {
        this.m_value = snmpSyntax.duplicate();
    }

    public byte typeId() {
        return 48;
    }

    public int encodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnEncodingException {
        int n2 = n;
        n = this.m_name.encodeASN(byArray, n, asnEncoder);
        int n3 = n = this.m_value.encodeASN(byArray, n, asnEncoder);
        int n4 = asnEncoder.buildHeader(byArray, n, this.typeId(), n3 - n2);
        SnmpUtil.rotate(byArray, n2, n3, n4);
        return n4;
    }

    public int decodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnDecodingException {
        Object[] objectArray = asnEncoder.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        byte by = (Byte)objectArray[1];
        int n2 = (Integer)objectArray[2];
        if (byArray.length - n < n2) {
            throw new AsnDecodingException("Buffer underflow error");
        }
        if (by != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        n = this.m_name.decodeASN(byArray, n, asnEncoder);
        this.m_value = SnmpUtil.getSyntaxObject(byArray[n]);
        if (this.m_value == null) {
            throw new AsnDecodingException("Unknown ASN.1 type");
        }
        n = this.m_value.decodeASN(byArray, n, asnEncoder);
        return n;
    }

    public SnmpSyntax duplicate() {
        return new SnmpVarBind(this);
    }

    public Object clone() {
        return new SnmpVarBind(this);
    }

    public String toString() {
        return this.m_name.toString() + " = " + this.m_value.toString();
    }
}

