/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.PrintStream;
import java.util.ArrayList;
import org.opennms.protocols.snmp.SnmpCounter32;
import org.opennms.protocols.snmp.SnmpCounter64;
import org.opennms.protocols.snmp.SnmpEndOfMibView;
import org.opennms.protocols.snmp.SnmpGauge32;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpNoSuchInstance;
import org.opennms.protocols.snmp.SnmpNoSuchObject;
import org.opennms.protocols.snmp.SnmpNull;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpOpaque;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpV2PartyClock;

class SnmpUtil {
    static ArrayList m_syntaxArray = null;

    SnmpUtil() {
    }

    static boolean registerSyntax(SnmpSyntax snmpSyntax) {
        boolean bl = false;
        ArrayList arrayList = m_syntaxArray;
        synchronized (arrayList) {
            boolean bl2 = true;
            int n = 0;
            while (n < m_syntaxArray.size()) {
                SnmpSyntax snmpSyntax2 = (SnmpSyntax)m_syntaxArray.get(n);
                if (snmpSyntax.typeId() == snmpSyntax2.typeId()) {
                    bl2 = false;
                    break;
                }
                ++n;
            }
            if (bl2) {
                bl = m_syntaxArray.add(snmpSyntax);
            }
        }
        return bl;
    }

    static SnmpSyntax getSyntaxObject(byte by) {
        SnmpSyntax snmpSyntax = null;
        switch (by) {
            case 2: {
                snmpSyntax = new SnmpInt32();
                break;
            }
            case 65: {
                snmpSyntax = new SnmpCounter32();
                break;
            }
            case 66: {
                snmpSyntax = new SnmpGauge32();
                break;
            }
            case 70: {
                snmpSyntax = new SnmpCounter64();
                break;
            }
            case 67: {
                snmpSyntax = new SnmpTimeTicks();
                break;
            }
            case 4: {
                snmpSyntax = new SnmpOctetString();
                break;
            }
            case 68: {
                snmpSyntax = new SnmpOpaque();
                break;
            }
            case 64: {
                snmpSyntax = new SnmpIPAddress();
                break;
            }
            case 6: {
                snmpSyntax = new SnmpObjectId();
                break;
            }
            case 71: {
                snmpSyntax = new SnmpV2PartyClock();
                break;
            }
            case -127: {
                snmpSyntax = new SnmpNoSuchInstance();
                break;
            }
            case -128: {
                snmpSyntax = new SnmpNoSuchObject();
                break;
            }
            case -126: {
                snmpSyntax = new SnmpEndOfMibView();
                break;
            }
            case 5: {
                snmpSyntax = new SnmpNull();
            }
        }
        if (snmpSyntax == null) {
            ArrayList arrayList = m_syntaxArray;
            synchronized (arrayList) {
                int n = m_syntaxArray.size() - 1;
                while (n >= 0) {
                    SnmpSyntax snmpSyntax2 = (SnmpSyntax)m_syntaxArray.get(n);
                    if (by == snmpSyntax2.typeId()) {
                        snmpSyntax = snmpSyntax2.duplicate();
                        break;
                    }
                    --n;
                }
            }
        }
        return snmpSyntax;
    }

    static void copy(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n2 + n4] = byArray[n + n4];
            ++n4;
        }
    }

    static void copy(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            nArray2[n2 + n4] = nArray[n + n4];
            ++n4;
        }
    }

    static void rotate(byte[] byArray, int n, int n2, int n3) {
        int n4 = n3 - n2;
        byte[] byArray2 = new byte[n4];
        SnmpUtil.copy(byArray, n2, byArray2, 0, n4);
        int n5 = n2 - n - 1;
        while (n5 >= 0) {
            byArray[n + n4 + n5] = byArray[n + n5];
            --n5;
        }
        SnmpUtil.copy(byArray2, 0, byArray, n, n4);
    }

    static void rotate(int[] nArray, int n, int n2, int n3) {
        int n4 = n3 - n2;
        int[] nArray2 = new int[n4];
        SnmpUtil.copy(nArray, n2, nArray2, 0, n4);
        int n5 = n2 - n - 1;
        while (n5 >= 0) {
            nArray[n + n4 + n5] = nArray[n + n5];
            --n5;
        }
        SnmpUtil.copy(nArray2, 0, nArray, n, n4);
    }

    /*
     * Unable to fully structure code
     */
    static void dumpHex(PrintStream var0, byte[] var1_1, int var2_2, int var3_3) {
        if (var2_2 + var3_3 <= var1_1.length) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = var1_1[var2_2];
            var0.print("0x");
            var0.print(Integer.toHexString(var4_4 >> 4 & 15));
            var0.print(Integer.toHexString(var4_4 & 15));
            var0.print(" ");
            --var3_3;
            ++var2_2;
lbl10:
            // 2 sources

            ** while (var3_3 > 0)
        }
lbl11:
        // 1 sources

    }

    static {
        m_syntaxArray = new ArrayList();
    }
}

