/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpUInt32
implements SnmpSyntax,
Cloneable,
Serializable {
    static final long serialVersionUID = 6360915905545058942L;
    private long m_value;
    private static final long MASK = 0xFFFFFFFFL;
    public static final byte ASNTYPE = 66;

    public SnmpUInt32() {
        this.m_value = 0L;
    }

    public SnmpUInt32(long l) {
        this.m_value = l & 0xFFFFFFFFL;
    }

    public SnmpUInt32(Long l) {
        this((long)l);
    }

    public SnmpUInt32(SnmpUInt32 snmpUInt32) {
        this.m_value = snmpUInt32.m_value;
    }

    public long getValue() {
        return this.m_value & 0xFFFFFFFFL;
    }

    public void setValue(long l) {
        this.m_value = l & 0xFFFFFFFFL;
    }

    public void setValue(Long l) {
        this.m_value = l & 0xFFFFFFFFL;
    }

    public byte typeId() {
        return 66;
    }

    public int encodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnEncodingException {
        return asnEncoder.buildUInteger32(byArray, n, this.typeId(), this.getValue());
    }

    public int decodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnDecodingException {
        Object[] objectArray = asnEncoder.parseUInteger32(byArray, n);
        if (((Byte)objectArray[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        this.setValue((Long)objectArray[2]);
        return (Integer)objectArray[0];
    }

    public SnmpSyntax duplicate() {
        return new SnmpUInt32(this);
    }

    public Object clone() {
        return new SnmpUInt32(this);
    }

    public String toString() {
        return Long.toString(this.getValue());
    }
}

