/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPacketHandler;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpPortal;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public final class SnmpTrapSession {
    public static final int ERROR_EXCEPTION = -1;
    public static final int ERROR_INVALID_PDU = -2;
    public static final int DEFAULT_PORT = 162;
    private int m_port;
    private SnmpPortal m_portal;
    private AsnEncoder m_encoder;
    private SnmpTrapHandler m_handler;
    private boolean m_threadException;
    private Throwable m_why;

    private SnmpTrapSession() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Illegal constructor call");
    }

    public SnmpTrapSession(SnmpTrapHandler snmpTrapHandler) throws SocketException {
        this.m_port = 162;
        this.m_encoder = new SnmpParameters().getEncoder();
        this.m_threadException = false;
        this.m_why = null;
        this.m_handler = snmpTrapHandler;
        this.m_portal = new SnmpPortal(new TrapHandler(this), this.m_encoder, this.m_port);
    }

    public SnmpTrapSession(SnmpTrapHandler snmpTrapHandler, int n) throws SocketException {
        this.m_port = n;
        this.m_encoder = new SnmpParameters().getEncoder();
        this.m_handler = snmpTrapHandler;
        this.m_portal = new SnmpPortal(new TrapHandler(this), this.m_encoder, this.m_port);
        this.m_threadException = false;
        this.m_why = null;
    }

    public SnmpTrapHandler getHandler() {
        return this.m_handler;
    }

    public void setHandler(SnmpTrapHandler snmpTrapHandler) {
        this.m_handler = snmpTrapHandler;
    }

    public void setAsnEncoder(AsnEncoder asnEncoder) {
        this.m_encoder = asnEncoder;
        this.m_portal.setAsnEncoder(asnEncoder);
    }

    public AsnEncoder getAsnEncoder() {
        return this.m_encoder;
    }

    public boolean isClosed() {
        return this.m_portal.isClosed();
    }

    public void close() {
        if (this.m_portal.isClosed()) {
            throw new IllegalStateException("Illegal operation, the session is already closed");
        }
        this.m_portal.close();
    }

    public void raise() throws Throwable {
        if (this.m_threadException) {
            throw this.m_why;
        }
    }

    public void send(SnmpPeer snmpPeer, SnmpPduTrap snmpPduTrap) throws SnmpPduEncodingException, AsnEncodingException, IOException {
        if (this.m_portal.isClosed()) {
            throw new IllegalStateException("Illegal operation, the session has been closed");
        }
        SnmpParameters snmpParameters = snmpPeer.getParameters();
        if (snmpParameters.getVersion() != 0) {
            throw new SnmpPduEncodingException("Cannot send pdu, invalid SNMP version");
        }
        AsnEncoder asnEncoder = snmpParameters.getEncoder();
        boolean bl = false;
        int n = 0;
        byte[] byArray = new byte[16384];
        SnmpInt32 snmpInt32 = new SnmpInt32(snmpParameters.getVersion());
        n = snmpInt32.encodeASN(byArray, n, asnEncoder);
        SnmpOctetString snmpOctetString = new SnmpOctetString(snmpParameters.getReadCommunity().getBytes());
        n = snmpOctetString.encodeASN(byArray, n, asnEncoder);
        int n2 = n = snmpPduTrap.encodeASN(byArray, n, asnEncoder);
        n = asnEncoder.buildHeader(byArray, n, (byte)48, n2);
        SnmpUtil.rotate(byArray, 0, n2, n);
        this.m_portal.send(snmpPeer, byArray, n);
    }

    public void send(SnmpPeer snmpPeer, SnmpPduPacket snmpPduPacket) throws SnmpPduEncodingException, AsnEncodingException, IOException {
        if (this.m_portal.isClosed()) {
            throw new IllegalStateException("Illegal operation, the session has been closed");
        }
        SnmpParameters snmpParameters = snmpPeer.getParameters();
        switch (snmpPduPacket.getCommand()) {
            case 167: {
                if (snmpParameters.getVersion() >= 1) break;
                throw new SnmpPduEncodingException("Cannot send pdu, invalid SNMP version");
            }
            default: {
                throw new SnmpPduEncodingException("Invalid pdu, not a trap");
            }
        }
        AsnEncoder asnEncoder = snmpParameters.getEncoder();
        boolean bl = false;
        int n = 0;
        byte[] byArray = new byte[16384];
        SnmpInt32 snmpInt32 = new SnmpInt32(snmpParameters.getVersion());
        n = snmpInt32.encodeASN(byArray, n, asnEncoder);
        SnmpOctetString snmpOctetString = new SnmpOctetString(snmpParameters.getReadCommunity().getBytes());
        n = snmpOctetString.encodeASN(byArray, n, asnEncoder);
        int n2 = n = snmpPduPacket.encodeASN(byArray, n, asnEncoder);
        n = asnEncoder.buildHeader(byArray, n, (byte)48, n2);
        SnmpUtil.rotate(byArray, 0, n2, n);
        this.m_portal.send(snmpPeer, byArray, n);
    }

    private class TrapHandler
    implements SnmpPacketHandler {
        private SnmpTrapSession m_forWhom;

        public TrapHandler(SnmpTrapSession snmpTrapSession2) {
            this.m_forWhom = snmpTrapSession2;
        }

        public void processSnmpMessage(InetAddress inetAddress, int n, SnmpInt32 snmpInt32, SnmpOctetString snmpOctetString, int n2, SnmpPduPacket snmpPduPacket) throws SnmpPduEncodingException {
            if (snmpInt32.getValue() != 1 && n2 != 167) {
                return;
            }
            try {
                SnmpTrapSession.this.m_handler.snmpReceivedTrap(this.m_forWhom, inetAddress, n, snmpOctetString, snmpPduPacket);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void processSnmpTrap(InetAddress inetAddress, int n, SnmpOctetString snmpOctetString, SnmpPduTrap snmpPduTrap) throws SnmpPduEncodingException {
            try {
                SnmpTrapSession.this.m_handler.snmpReceivedTrap(this.m_forWhom, inetAddress, n, snmpOctetString, snmpPduTrap);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void processBadDatagram(DatagramPacket datagramPacket) {
        }

        public void processException(Exception exception) {
            try {
                SnmpTrapSession.this.m_handler.snmpTrapSessionError(this.m_forWhom, -1, exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }
}

