/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.IOException;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

class SnmpRequest
implements Runnable {
    SnmpSession m_session;
    SnmpSyntax m_pdu;
    SnmpHandler m_handler;
    int m_timesSent;
    boolean m_expired;

    SnmpRequest(SnmpSession snmpSession, SnmpPduPacket snmpPduPacket, SnmpHandler snmpHandler) {
        this.m_session = snmpSession;
        this.m_pdu = snmpPduPacket;
        this.m_expired = false;
        this.m_timesSent = 0;
        this.m_handler = snmpHandler;
    }

    SnmpRequest(SnmpSession snmpSession, SnmpPduTrap snmpPduTrap, SnmpHandler snmpHandler) {
        this.m_session = snmpSession;
        this.m_pdu = snmpPduTrap;
        this.m_expired = false;
        this.m_timesSent = 0;
        this.m_handler = snmpHandler;
    }

    public void run() {
        if (this.m_expired) {
            return;
        }
        if (this.m_timesSent < this.m_session.getPeer().getRetries()) {
            ++this.m_timesSent;
            try {
                this.m_session.transmit(this);
                if (this.m_pdu instanceof SnmpPduPacket) {
                    if (((SnmpPduPacket)this.m_pdu).getCommand() != 167) {
                        this.m_session.getTimer().schedule(this, this.m_session.getPeer().getTimeout());
                    } else {
                        this.m_expired = true;
                    }
                } else if (this.m_pdu instanceof SnmpPduTrap) {
                    this.m_expired = true;
                }
            }
            catch (IOException iOException) {
                this.m_expired = true;
                try {
                    this.m_handler.snmpInternalError(this.m_session, -2, this.m_pdu);
                }
                catch (Exception exception) {
                }
            }
            catch (SnmpPduEncodingException snmpPduEncodingException) {
                this.m_expired = true;
                try {
                    this.m_handler.snmpInternalError(this.m_session, -3, this.m_pdu);
                }
                catch (Exception exception) {
                }
            }
            catch (AsnEncodingException asnEncodingException) {
                this.m_expired = true;
                try {
                    this.m_handler.snmpInternalError(this.m_session, -3, this.m_pdu);
                }
                catch (Exception exception) {}
            }
        } else {
            this.m_expired = true;
            try {
                this.m_handler.snmpTimeoutError(this.m_session, this.m_pdu);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

