/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPacketHandler;
import org.opennms.protocols.snmp.SnmpPduBulk;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;

class SnmpPortal {
    private SnmpPacketHandler m_handler;
    private DatagramSocket m_comm;
    private Thread m_recvThread;
    private AsnEncoder m_encoder;
    private volatile boolean m_isClosing;
    private boolean bSocketSoTimeoutRequired = true;
    private static final String PROP_SOCKET_TIMEOUT_REQUIRED = "org.opennms.joeSNMP.vmhacks.socketSoTimeoutRequired";
    private static final String PROP_SOCKET_TIMEOUT_PERIOD = "org.opennms.joeSNMP.vmhacks.socketSoTimeoutPeriod";

    private SnmpPortal() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Illegal constructor call");
    }

    SnmpPortal(SnmpPacketHandler snmpPacketHandler, AsnEncoder asnEncoder, int n) throws SocketException {
        if (snmpPacketHandler == null || asnEncoder == null || n < 0) {
            throw new IllegalArgumentException("Invalid argument");
        }
        this.m_handler = snmpPacketHandler;
        this.m_comm = new DatagramSocket(n);
        this.bSocketSoTimeoutRequired = true;
        String string = System.getProperty(PROP_SOCKET_TIMEOUT_REQUIRED);
        String string2 = System.getProperty("os.name");
        if (string != null && string.equals("no")) {
            this.bSocketSoTimeoutRequired = false;
        }
        if (this.bSocketSoTimeoutRequired) {
            String string3 = System.getProperty(PROP_SOCKET_TIMEOUT_PERIOD);
            int n2 = 3000;
            if (string3 != null) {
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 3000;
                }
            }
            this.m_comm.setSoTimeout(n2);
        } else if (string2 != null && string2.equalsIgnoreCase("linux")) {
            this.m_comm.setSoTimeout(100);
        }
        this.m_isClosing = false;
        this.m_recvThread = new Thread((Runnable)new Receiver(), "SnmpPortal-" + n);
        this.m_encoder = asnEncoder;
        this.m_recvThread.start();
    }

    void handlePkt(DatagramPacket datagramPacket) throws SnmpPduEncodingException, AsnDecodingException {
        byte[] byArray = datagramPacket.getData();
        int n = 0;
        Object[] objectArray = this.m_encoder.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        byte by = (Byte)objectArray[1];
        int n2 = (Integer)objectArray[2];
        if (by != 48) {
            throw new AsnDecodingException("Invalid SNMP ASN.1 type");
        }
        if (n2 > datagramPacket.getLength() - n) {
            throw new SnmpPduEncodingException("Insufficent data in packet");
        }
        SnmpInt32 snmpInt32 = new SnmpInt32();
        n = snmpInt32.decodeASN(byArray, n, this.m_encoder);
        if (snmpInt32.getValue() != 0 && snmpInt32.getValue() != 1) {
            throw new SnmpPduEncodingException("Invalid protocol version");
        }
        SnmpOctetString snmpOctetString = new SnmpOctetString();
        n = snmpOctetString.decodeASN(byArray, n, this.m_encoder);
        objectArray = this.m_encoder.parseHeader(byArray, n);
        int n3 = ((Byte)objectArray[1]).intValue() + 256;
        switch (n3) {
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 166: 
            case 167: 
            case 168: {
                SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
                n = snmpPduRequest.decodeASN(byArray, n, this.m_encoder);
                this.m_handler.processSnmpMessage(datagramPacket.getAddress(), datagramPacket.getPort(), snmpInt32, snmpOctetString, n3, snmpPduRequest);
                break;
            }
            case 165: {
                SnmpPduBulk snmpPduBulk = new SnmpPduBulk();
                n = snmpPduBulk.decodeASN(byArray, n, this.m_encoder);
                this.m_handler.processSnmpMessage(datagramPacket.getAddress(), datagramPacket.getPort(), snmpInt32, snmpOctetString, n3, snmpPduBulk);
                break;
            }
            case 164: {
                SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
                n = snmpPduTrap.decodeASN(byArray, n, this.m_encoder);
                this.m_handler.processSnmpTrap(datagramPacket.getAddress(), datagramPacket.getPort(), snmpOctetString, snmpPduTrap);
                break;
            }
            default: {
                throw new SnmpPduEncodingException("No matching PDU type found");
            }
        }
    }

    void send(SnmpPeer snmpPeer, byte[] byArray, int n) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, snmpPeer.getPeer(), snmpPeer.getPort());
        this.m_comm.send(datagramPacket);
    }

    void send(SnmpPeer snmpPeer, byte[] byArray) throws IOException {
        this.send(snmpPeer, byArray, byArray.length);
    }

    void setPacketHandler(SnmpPacketHandler snmpPacketHandler) {
        if (snmpPacketHandler == null) {
            throw new IllegalArgumentException("The packet handler must not be null");
        }
        this.m_handler = snmpPacketHandler;
    }

    SnmpPacketHandler getPacketHandler() {
        return this.m_handler;
    }

    void setAsnEncoder(AsnEncoder asnEncoder) {
        if (asnEncoder == null) {
            throw new IllegalArgumentException("The ASN.1 codec must not be null");
        }
        this.m_encoder = asnEncoder;
    }

    AsnEncoder getAsnEncoder() {
        return this.m_encoder;
    }

    boolean isClosed() {
        return this.m_isClosing;
    }

    void close() {
        this.m_isClosing = true;
        this.m_comm.close();
        try {
            if (!this.m_recvThread.equals(Thread.currentThread())) {
                this.m_recvThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private class Receiver
    implements Runnable {
        private Receiver() {
        }

        private int setup() {
            int n = 16384;
            try {
                SnmpPortal.this.m_comm.setReceiveBufferSize(n);
            }
            catch (SocketException socketException) {
                n = 0;
            }
            if (n == 0) {
                try {
                    n = SnmpPortal.this.m_comm.getReceiveBufferSize();
                }
                catch (SocketException socketException) {
                    n = 0;
                }
            }
            return n;
        }

        public void run() {
            int n = this.setup();
            if (n == 0) {
                return;
            }
            byte[] byArray = new byte[n];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, n);
            while (!SnmpPortal.this.m_isClosing) {
                try {
                    datagramPacket.setLength(n);
                    SnmpPortal.this.m_comm.receive(datagramPacket);
                    SnmpPortal.this.handlePkt(datagramPacket);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (SnmpPduEncodingException snmpPduEncodingException) {
                    SnmpPortal.this.m_handler.processBadDatagram(datagramPacket);
                }
                catch (AsnDecodingException asnDecodingException) {
                    SnmpPortal.this.m_handler.processBadDatagram(datagramPacket);
                }
                catch (Exception exception) {
                    if (SnmpPortal.this.m_isClosing) continue;
                    SnmpPortal.this.m_handler.processException(exception);
                }
            }
        }
    }
}

