/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.util.ArrayList;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpUInt32;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.SnmpVarBind;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpPduTrap
implements SnmpSyntax,
Cloneable {
    private SnmpObjectId m_enterprise;
    private SnmpIPAddress m_agentAddr;
    private int m_generic;
    private int m_specific;
    private long m_tstamp;
    private ArrayList m_variables;
    public static final int TRAP = 164;
    public static final int GenericColdStart = 0;
    public static final int GenericWarmStart = 1;
    public static final int GenericLinkDown = 2;
    public static final int GenericLinkUp = 3;
    public static final int GenericAuthenticationFailure = 4;
    public static final int GenericEgpNeighborLoss = 5;
    public static final int GenericEnterpriseSpecific = 6;

    public SnmpPduTrap() {
        this.m_enterprise = new SnmpObjectId();
        this.m_agentAddr = new SnmpIPAddress();
        this.m_generic = 0;
        this.m_specific = 0;
        this.m_tstamp = 0L;
        this.m_variables = new ArrayList();
    }

    protected SnmpPduTrap(SnmpPduTrap snmpPduTrap) {
        this.m_enterprise = snmpPduTrap.m_enterprise;
        this.m_agentAddr = snmpPduTrap.m_agentAddr;
        this.m_generic = snmpPduTrap.m_generic;
        this.m_specific = snmpPduTrap.m_specific;
        this.m_tstamp = snmpPduTrap.m_tstamp;
        this.m_variables = new ArrayList(snmpPduTrap.m_variables.size());
        int n = snmpPduTrap.m_variables.size() - 1;
        while (n >= 0) {
            this.m_variables.set(n, ((SnmpVarBind)snmpPduTrap.m_variables.get(n)).duplicate());
            --n;
        }
    }

    public SnmpObjectId getEnterprise() {
        return this.m_enterprise;
    }

    public void setEnterprise(SnmpObjectId snmpObjectId) {
        this.m_enterprise = (SnmpObjectId)snmpObjectId.clone();
    }

    public void setEnterprise(String string) {
        this.m_enterprise = new SnmpObjectId(string);
    }

    public SnmpIPAddress getAgentAddress() {
        return this.m_agentAddr;
    }

    public void setAgentAddress(SnmpIPAddress snmpIPAddress) {
        this.m_agentAddr = snmpIPAddress;
    }

    public int getGeneric() {
        return this.m_generic;
    }

    public void setGeneric(int n) {
        this.m_generic = n;
    }

    public int getSpecific() {
        return this.m_specific;
    }

    public void setSpecific(int n) {
        this.m_specific = n;
    }

    public long getTimeStamp() {
        return this.m_tstamp;
    }

    public void setTimeStamp(long l) {
        this.m_tstamp = l;
    }

    public int getLength() {
        return this.m_variables.size();
    }

    public void addVarBind(SnmpVarBind snmpVarBind) {
        this.m_variables.add(snmpVarBind);
    }

    public void addVarBindAt(int n, SnmpVarBind snmpVarBind) {
        this.m_variables.add(n, snmpVarBind);
    }

    public SnmpVarBind getVarBindAt(int n) {
        return (SnmpVarBind)this.m_variables.get(n);
    }

    public void setVarBindAt(int n, SnmpVarBind snmpVarBind) {
        this.m_variables.set(n, snmpVarBind);
    }

    public SnmpVarBind removeVarBindAt(int n) {
        return (SnmpVarBind)this.m_variables.remove(n);
    }

    public SnmpVarBind[] toVarBindArray() {
        return (SnmpVarBind[])this.m_variables.toArray();
    }

    public byte typeId() {
        return -92;
    }

    public int encodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnEncodingException {
        int n2 = n;
        n = this.m_enterprise.encodeASN(byArray, n, asnEncoder);
        n = this.m_agentAddr.encodeASN(byArray, n, asnEncoder);
        SnmpSyntax snmpSyntax = new SnmpInt32(this.m_generic);
        n = ((SnmpInt32)snmpSyntax).encodeASN(byArray, n, asnEncoder);
        ((SnmpInt32)snmpSyntax).setValue(this.m_specific);
        n = ((SnmpInt32)snmpSyntax).encodeASN(byArray, n, asnEncoder);
        snmpSyntax = new SnmpTimeTicks(this.m_tstamp);
        int n3 = n = ((SnmpUInt32)snmpSyntax).encodeASN(byArray, n, asnEncoder);
        int n4 = this.m_variables.size();
        int n5 = 0;
        while (n5 < n4) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.m_variables.get(n5);
            n = snmpVarBind.encodeASN(byArray, n, asnEncoder);
            ++n5;
        }
        int n6 = n;
        n = asnEncoder.buildHeader(byArray, n, (byte)48, n6 - n3);
        SnmpUtil.rotate(byArray, n3, n6, n);
        n6 = n;
        n = asnEncoder.buildHeader(byArray, n, this.typeId(), n6 - n2);
        SnmpUtil.rotate(byArray, n2, n6, n);
        return n;
    }

    public int decodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnDecodingException {
        Object[] objectArray = asnEncoder.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        int n2 = ((Byte)objectArray[1]).intValue();
        int n3 = (Integer)objectArray[2];
        int n4 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        if (164 != n2) {
            throw new AsnDecodingException("Invalid SNMP command, Not a Trap");
        }
        n = this.m_enterprise.decodeASN(byArray, n, asnEncoder);
        n = this.m_agentAddr.decodeASN(byArray, n, asnEncoder);
        SnmpSyntax snmpSyntax = new SnmpInt32();
        n = ((SnmpInt32)snmpSyntax).decodeASN(byArray, n, asnEncoder);
        this.m_generic = ((SnmpInt32)snmpSyntax).getValue();
        n = ((SnmpInt32)snmpSyntax).decodeASN(byArray, n, asnEncoder);
        this.m_specific = ((SnmpInt32)snmpSyntax).getValue();
        snmpSyntax = new SnmpTimeTicks();
        n = ((SnmpUInt32)snmpSyntax).decodeASN(byArray, n, asnEncoder);
        this.m_tstamp = ((SnmpUInt32)snmpSyntax).getValue();
        objectArray = asnEncoder.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        n3 = (Integer)objectArray[2];
        byte by = (Byte)objectArray[1];
        if (by != 48) {
            throw new AsnDecodingException("Invalid SNMP variable list");
        }
        n4 = n;
        this.m_variables.clear();
        SnmpVarBind snmpVarBind = new SnmpVarBind();
        while (n3 > 0) {
            n = snmpVarBind.decodeASN(byArray, n, asnEncoder);
            n3 -= n - n4;
            n4 = n;
            this.m_variables.add(snmpVarBind.duplicate());
        }
        return n;
    }

    public SnmpSyntax duplicate() {
        return new SnmpPduTrap(this);
    }

    public Object clone() {
        return new SnmpPduTrap(this);
    }
}

