/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.SnmpVarBind;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public abstract class SnmpPduPacket
implements SnmpSyntax,
Cloneable {
    private static int sm_seq = 0;
    private int m_command;
    private int m_requestId;
    private ArrayList m_variables;
    protected int m_errStatus;
    protected int m_errIndex;
    public static final int GET = 160;
    public static final int GETNEXT = 161;
    public static final int RESPONSE = 162;
    public static final int SET = 163;
    public static final int GETBULK = 165;
    public static final int INFORM = 166;
    public static final int V2TRAP = 167;
    public static final int REPORT = 168;
    public static final int ErrNoError = 0;
    public static final int ErrTooBig = 1;
    public static final int ErrNoSuchName = 2;
    public static final int ErrBadValue = 3;
    public static final int ErrReadOnly = 4;
    public static final int ErrGenError = 5;
    public static final int ErrNoAccess = 6;
    public static final int ErrWrongType = 7;
    public static final int ErrWrongLength = 8;
    public static final int ErrWrongEncoding = 9;
    public static final int ErrWrongValue = 10;
    public static final int ErrNoCreation = 11;
    public static final int ErrInconsistentValue = 12;
    public static final int ErrResourceUnavailable = 13;
    public static final int ErrCommitFailed = 14;
    public static final int ErrUndoFailed = 15;
    public static final int ErrAuthorizationError = 16;
    public static final int ErrNotWritable = 17;
    public static final int ErrInconsistentName = 18;

    protected SnmpPduPacket() {
        this.m_command = 0;
        this.m_requestId = 0;
        this.m_errStatus = 0;
        this.m_errIndex = 0;
        this.m_variables = new ArrayList();
    }

    protected SnmpPduPacket(SnmpPduPacket snmpPduPacket) {
        this.m_command = snmpPduPacket.m_command;
        this.m_requestId = snmpPduPacket.m_requestId;
        this.m_errStatus = snmpPduPacket.m_errStatus;
        this.m_errIndex = snmpPduPacket.m_errIndex;
        int n = snmpPduPacket.m_variables.size();
        this.m_variables = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this.m_variables.add(n2, ((SnmpVarBind)snmpPduPacket.m_variables.get(n2)).duplicate());
            ++n2;
        }
    }

    protected SnmpPduPacket(int n) {
        this();
        this.m_command = n;
    }

    protected SnmpPduPacket(int n, SnmpVarBind[] snmpVarBindArray) {
        this(n);
        if (snmpVarBindArray != null) {
            this.m_variables.ensureCapacity(snmpVarBindArray.length);
            int n2 = 0;
            while (n2 < snmpVarBindArray.length) {
                this.m_variables.add(snmpVarBindArray[n2].duplicate());
                ++n2;
            }
        }
    }

    public static synchronized int nextSequence() {
        if (sm_seq == 0) {
            Date date = new Date();
            Random random = new Random(date.getTime());
            sm_seq = random.nextInt();
        }
        return sm_seq++;
    }

    public int getCommand() {
        return this.m_command;
    }

    public void setCommand(int n) {
        this.m_command = n;
    }

    public int getRequestId() {
        return this.m_requestId;
    }

    public void setRequestId(int n) {
        this.m_requestId = n;
    }

    public int getLength() {
        return this.m_variables.size();
    }

    public void addVarBind(SnmpVarBind snmpVarBind) {
        this.m_variables.add(snmpVarBind);
    }

    public void addVarBindAt(int n, SnmpVarBind snmpVarBind) {
        this.m_variables.add(n, snmpVarBind);
    }

    public SnmpVarBind getVarBindAt(int n) {
        return (SnmpVarBind)this.m_variables.get(n);
    }

    public void setVarBindAt(int n, SnmpVarBind snmpVarBind) {
        this.m_variables.set(n, snmpVarBind);
    }

    public SnmpVarBind removeVarBindAt(int n) {
        return (SnmpVarBind)this.m_variables.remove(n);
    }

    public SnmpVarBind[] toVarBindArray() {
        Object[] objectArray = this.m_variables.toArray();
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            snmpVarBindArray[n] = (SnmpVarBind)objectArray[n];
            ++n;
        }
        return snmpVarBindArray;
    }

    public byte typeId() {
        return (byte)(this.m_command & 0xFF);
    }

    public int encodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnEncodingException {
        int n2 = n;
        SnmpInt32 snmpInt32 = new SnmpInt32(this.m_requestId);
        n = snmpInt32.encodeASN(byArray, n, asnEncoder);
        snmpInt32.setValue(this.m_errStatus);
        n = snmpInt32.encodeASN(byArray, n, asnEncoder);
        snmpInt32.setValue(this.m_errIndex);
        int n3 = n = snmpInt32.encodeASN(byArray, n, asnEncoder);
        int n4 = this.m_variables.size();
        int n5 = 0;
        while (n5 < n4) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)this.m_variables.get(n5);
            n = snmpVarBind.encodeASN(byArray, n, asnEncoder);
            ++n5;
        }
        int n6 = n;
        n = asnEncoder.buildHeader(byArray, n, (byte)48, n6 - n3);
        SnmpUtil.rotate(byArray, n3, n6, n);
        n6 = n;
        n = asnEncoder.buildHeader(byArray, n, this.typeId(), n6 - n2);
        SnmpUtil.rotate(byArray, n2, n6, n);
        return n;
    }

    public int decodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnDecodingException {
        Object[] objectArray = asnEncoder.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        int n2 = ((Byte)objectArray[1]).intValue();
        int n3 = (Integer)objectArray[2];
        int n4 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        this.m_command = n2;
        SnmpInt32 snmpInt32 = new SnmpInt32();
        n = snmpInt32.decodeASN(byArray, n, asnEncoder);
        this.m_requestId = snmpInt32.getValue();
        n = snmpInt32.decodeASN(byArray, n, asnEncoder);
        this.m_errStatus = snmpInt32.getValue();
        n = snmpInt32.decodeASN(byArray, n, asnEncoder);
        this.m_errIndex = snmpInt32.getValue();
        objectArray = asnEncoder.parseHeader(byArray, n);
        n = (Integer)objectArray[0];
        n3 = (Integer)objectArray[2];
        byte by = (Byte)objectArray[1];
        if (by != 48) {
            throw new AsnDecodingException("Invalid SNMP variable list");
        }
        n4 = n;
        this.m_variables.clear();
        SnmpVarBind snmpVarBind = new SnmpVarBind();
        while (n3 > 0) {
            n = snmpVarBind.decodeASN(byArray, n, asnEncoder);
            n3 -= n - n4;
            n4 = n;
            this.m_variables.add(snmpVarBind.duplicate());
        }
        return n;
    }

    public abstract SnmpSyntax duplicate();

    public abstract Object clone();
}

