/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpOctetString
implements SnmpSyntax,
Cloneable,
Serializable {
    static final long serialVersionUID = 1848780739976444105L;
    private byte[] m_data = null;
    public static final byte ASNTYPE = 4;

    public SnmpOctetString() {
    }

    public SnmpOctetString(byte[] byArray) {
        this();
        if (byArray != null) {
            this.m_data = new byte[byArray.length];
            SnmpUtil.copy(byArray, 0, this.m_data, 0, byArray.length);
        }
    }

    public SnmpOctetString(SnmpOctetString snmpOctetString) {
        this(snmpOctetString.m_data);
    }

    public byte[] getString() {
        return this.m_data;
    }

    public void setString(byte[] byArray) {
        this.m_data = null;
        if (byArray != null) {
            this.m_data = new byte[byArray.length];
            SnmpUtil.copy(byArray, 0, this.m_data, 0, byArray.length);
        }
    }

    public void setString(String string) {
        this.m_data = null;
        if (string != null) {
            this.m_data = string.getBytes();
        }
    }

    public int getLength() {
        int n = 0;
        if (this.m_data != null) {
            n = this.m_data.length;
        }
        return n;
    }

    public byte typeId() {
        return 4;
    }

    public int encodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnEncodingException {
        if (this.m_data == null) {
            throw new AsnEncodingException("No data in octet string");
        }
        return asnEncoder.buildString(byArray, n, this.typeId(), this.m_data);
    }

    public int decodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnDecodingException {
        Object[] objectArray = asnEncoder.parseString(byArray, n);
        if (((Byte)objectArray[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        this.m_data = (byte[])objectArray[2];
        return (Integer)objectArray[0];
    }

    public SnmpSyntax duplicate() {
        return new SnmpOctetString(this);
    }

    public Object clone() {
        return new SnmpOctetString(this);
    }

    public String toString() {
        boolean bl = false;
        int n = 0;
        while (n < this.m_data.length) {
            byte by = this.m_data[n];
            if (by < 32 && by != 10 && by != 13 || by == 127) {
                bl = true;
                break;
            }
            ++n;
        }
        String string = null;
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.m_data.length) {
                int n3 = this.m_data[n2] & 0xFF;
                if (n3 < 16) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toString(n3, 16).toUpperCase());
                if (n2 < this.m_data.length - 1) {
                    stringBuffer.append(' ');
                }
                ++n2;
            }
            string = stringBuffer.toString();
        } else {
            string = new String(this.m_data);
        }
        return string;
    }
}

