/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.protocols.snmp.SnmpBadConversionException;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpSyntax;

public class SnmpIPAddress
extends SnmpOctetString {
    static final long serialVersionUID = -4375760318106654741L;
    public static final byte ASNTYPE = 64;

    public SnmpIPAddress() {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        this.setString(byArray);
    }

    public SnmpIPAddress(byte[] byArray) {
        super(byArray);
    }

    public SnmpIPAddress(SnmpIPAddress snmpIPAddress) {
        super(snmpIPAddress);
    }

    public SnmpIPAddress(SnmpOctetString snmpOctetString) {
        super(snmpOctetString);
    }

    public byte typeId() {
        return 64;
    }

    public SnmpSyntax duplicate() {
        return new SnmpIPAddress(this);
    }

    public Object clone() {
        return new SnmpIPAddress(this);
    }

    public InetAddress convertToIpAddress() throws SnmpBadConversionException {
        byte[] byArray = this.getString();
        if (byArray == null || byArray.length != 4) {
            throw new SnmpBadConversionException("Invalid IP Address Length");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(byArray[0] < 0 ? 256 + byArray[0] : byArray[0]).append('.');
        stringBuffer.append(byArray[1] < 0 ? 256 + byArray[1] : byArray[1]).append('.');
        stringBuffer.append(byArray[2] < 0 ? 256 + byArray[2] : byArray[2]).append('.');
        stringBuffer.append(byArray[3] < 0 ? 256 + byArray[3] : byArray[3]);
        try {
            return InetAddress.getByName(stringBuffer.toString());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SnmpBadConversionException("Invalid IP Address?");
        }
    }

    public String toString() {
        byte[] byArray = this.getString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(byArray[0] < 0 ? 256 + byArray[0] : byArray[0]).append('.');
        stringBuffer.append(byArray[1] < 0 ? 256 + byArray[1] : byArray[1]).append('.');
        stringBuffer.append(byArray[2] < 0 ? 256 + byArray[2] : byArray[2]).append('.');
        stringBuffer.append(byArray[3] < 0 ? 256 + byArray[3] : byArray[3]);
        return stringBuffer.toString();
    }
}

