/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.Serializable;
import java.math.BigInteger;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpCounter64
implements SnmpSyntax,
Cloneable,
Serializable {
    private BigInteger m_value;
    public static final byte ASNTYPE = 70;

    public SnmpCounter64() {
        this.m_value = BigInteger.valueOf(0L);
        this.m_value.clearBit(65);
    }

    public SnmpCounter64(long l) {
        this.m_value = BigInteger.valueOf(l & Long.MAX_VALUE);
        this.m_value.clearBit(65);
    }

    public SnmpCounter64(BigInteger bigInteger) {
        this.m_value = new BigInteger(bigInteger.toByteArray());
        this.m_value.clearBit(65);
    }

    public SnmpCounter64(SnmpCounter64 snmpCounter64) {
        this.m_value = new BigInteger(snmpCounter64.m_value.toByteArray());
        this.m_value.clearBit(65);
    }

    public BigInteger getValue() {
        return this.m_value;
    }

    public void setValue(BigInteger bigInteger) {
        this.m_value = new BigInteger(bigInteger.toByteArray());
        this.m_value.clearBit(65);
    }

    public byte typeId() {
        return 70;
    }

    public int encodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnEncodingException {
        return asnEncoder.buildUInteger64(byArray, n, this.typeId(), this.getValue());
    }

    public int decodeASN(byte[] byArray, int n, AsnEncoder asnEncoder) throws AsnDecodingException {
        Object[] objectArray = asnEncoder.parseUInteger64(byArray, n);
        if (((Byte)objectArray[1]).byteValue() != this.typeId()) {
            throw new AsnDecodingException("Invalid ASN.1 type");
        }
        this.setValue((BigInteger)objectArray[2]);
        return (Integer)objectArray[0];
    }

    public SnmpSyntax duplicate() {
        return new SnmpCounter64(this);
    }

    public Object clone() {
        return new SnmpCounter64(this);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

